﻿---
title: Unenroll Elastic Agents
description: You can unenroll Elastic Agents to invalidate the API key used to connect to Elasticsearch. In Fleet, select Agents.To unenroll a single agent, choose...
url: https://www.elastic.co/docs/reference/fleet/unenroll-elastic-agent
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Unenroll Elastic Agents
You can unenroll Elastic Agents to invalidate the API key used to connect to Elasticsearch.
1. In Fleet, select **Agents**.
2. To unenroll a single agent, choose **Unenroll agent** from the **Actions** menu next to the agent you want to unenroll.
3. To unenroll multiple agents, bulk select the agents and click **Unenroll agents**.
   Unable to select multiple agents? Confirm that your subscription level supports **selective agent unenrollment** in Fleet. For more information, refer to [Elastic subscriptions](https://www.elastic.co/subscriptions).

Unenrolled agents will continue to run, but will not be able to send data. They will show this error instead: `invalid api key to authenticate with fleet`.
<tip>
  If unenrollment hangs, select **Force unenroll** to invalidate all API keys related to the agent and change the status to `inactive` so that the agent no longer appears in Fleet.
</tip>

<note>
  Enrollment handling for Elastic Agent in a containerized environment has some special nuances.
  For details refer to [Enrollment handing for containerized agents](https://www.elastic.co/docs/reference/fleet/enrollment-handling-containerized-agent).
</note>