﻿---
title: Truncate fields
description: The truncate_fields processor truncates a field to a given size. If the size of the field is smaller than the limit, the field is left as is. This configuration...
url: https://www.elastic.co/docs/reference/fleet/truncate_fields-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Truncate fields
The `truncate_fields` processor truncates a field to a given size. If the size of the field is smaller than the limit, the field is left as is.

## Example

This configuration truncates the field named `message` to five characters:
```yaml
  - truncate_fields:
      fields:
        - message
      max_characters: 5
      fail_on_error: false
      ignore_missing: true
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that your processor configurations cannot refer to fields that are created by ingest pipelines or Logstash. For more limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name             | Required | Default | Description                                                                                                                                                         |
|------------------|----------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `fields`         | Yes      |         | List of fields to truncate. You can use the `@metadata.` prefix to truncate values in the event metadata instead of event fields.                                   |
| `max_bytes`      | Yes      |         | Maximum number of bytes in a field. Mutually exclusive with `max_characters`.                                                                                       |
| `max_characters` | Yes      |         | Maximum number of characters in a field. Mutually exclusive with `max_bytes`.                                                                                       |
| `fail_on_error`  | No       | `true`  | If `true` and an error occurs, any changes to the event are reverted, and the original event is returned. If `false`, processing continues even if an error occurs. |
| `ignore_missing` | No       | `false` | Whether to ignore events that lack the source field. If `false`, processing of the event fails if a field is missing.                                               |