﻿---
title: One-way and mutual TLS certifications flow
description: This page provides an overview of the relationship between the various certificates and certificate authorities (CAs) that you configure for Fleet Server...
url: https://www.elastic.co/docs/reference/fleet/tls-overview
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# One-way and mutual TLS certifications flow
This page provides an overview of the relationship between the various certificates and certificate authorities (CAs) that you configure for Fleet Server and Elastic Agent, using the `elastic-agent install` TLS command options.
You can also configure one-way and mutual TLS connections using Kibana. <applies-to>Elastic Stack: Generally available since 9.1</applies-to>
- [Simple one-way TLS connection](#one-way-tls-connection)
- [Mutual TLS connection](#mutual-tls-connection)
- [Configure TLS/mTLS settings in Kibana](#tls-ui-settings) <applies-to>Elastic Stack: Generally available since 9.1</applies-to>


## Simple one-way TLS connection

<applies-to>
  - Elastic Cloud Serverless: Unavailable
</applies-to>

The following `elastic-agent install` command configures a Fleet Server with the required certificates and certificate authorities to enable one-way TLS connections between the components involved:
```shell
elastic-agent install --url=https://your-fleet-server.elastic.co:443 \
--certificate-authorities=/path/to/fleet-ca \
--fleet-server-es=https://es.elastic.com:443 \
--fleet-server-es-ca=/path/to/es-ca \
--fleet-server-cert=/path/to/fleet-cert \
--fleet-server-cert-key=/path/to/fleet-cert-key \
--fleet-server-service-token=FLEET-SERVER-SERVICE-TOKEN \
--fleet-server-policy=FLEET-SERVER-POLICY-ID \
--fleet-server-port=8220
```

Elastic Agent is configured with `fleet-ca` as the certificate authority that it needs to validate certificates from Fleet Server.
During the TLS connection setup, Fleet Server presents its certificate `fleet-cert` to the agent and the agent (as a client) uses `fleet-ca` to validate the presented certificate.
![Diagram of one-way TLS connection between Fleet Server and Elastic Agent](https://www.elastic.co/docs/reference/fleet/images/tls-overview-oneway-fs-agent.png)

Fleet Server also establishes a secure connection to an Elasticsearch cluster. In this case, Fleet Server is configured with the certificate authority from the Elasticsearch `es-ca`. Elasticsearch presents its certificate, `es-cert`, and Fleet Server validates the presented certificate using the certificate authority `es-ca`.
![Diagram of one-way TLS connection between Fleet Server and Elasticsearch](https://www.elastic.co/docs/reference/fleet/images/tls-overview-oneway-fs-es.png)


### Relationship between components in a one-way TLS connection

![Diagram of one-way TLS connection between components](https://www.elastic.co/docs/reference/fleet/images/tls-overview-oneway-all.jpg)


## Mutual TLS connection

<applies-to>
  - Elastic Cloud Serverless: Unavailable
</applies-to>

The following `elastic-agent install` command configures a Fleet Server with the required certificates and certificate authorities to enable mutual TLS connections between the components involved:
```shell
elastic-agent install --url=https://your-fleet-server.elastic.co:443 \
--certificate-authorities=/path/to/fleet-ca,/path/to/agent-ca \
--elastic-agent-cert=/path/to/agent-cert \
--elastic-agent-cert-key=/path/to/agent-cert-key \
--elastic-agent-cert-key-passphrase=/path/to/agent-cert-key-passphrase \
--fleet-server-es=https://es.elastic.com:443 \
--fleet-server-es-ca=/path/to/es-ca \
--fleet-server-es-cert=/path/to/fleet-es-cert \
--fleet-server-es-cert-key=/path/to/fleet-es-cert-key \
--fleet-server-cert=/path/to/fleet-cert \
--fleet-server-cert-key=/path/to/fleet-cert-key \
--fleet-server-client-auth=required \
--fleet-server-service-token=FLEET-SERVER-SERVICE-TOKEN \
--fleet-server-policy=FLEET-SERVER-POLICY-ID \
--fleet-server-port=8220
```

As with the [one-way TLS example](#one-way-tls-connection), Elastic Agent is configured with `fleet-ca` as the certificate authority that it needs to validate certificates from the Fleet Server. Fleet Server presents its certificate `fleet-cert` to the agent and the agent (as a client) uses `fleet-ca` to validate the presented certificate.
To establish a mutual TLS connection, the agent presents its certificate, `agent-cert`, and Fleet Server validates this certificate using the `agent-ca` that it has stored in memory.
![Diagram of mutual TLS connection between Fleet Server and Elastic Agent](https://www.elastic.co/docs/reference/fleet/images/tls-overview-mutual-fs-agent.png)

Fleet Server can also establish a mutual TLS connection to the Elasticsearch cluster. In this case, Fleet Server is configured with the certificate authority from the Elasticsearch `es-ca` and uses this to validate the certificate `es-cert` presented to it by Elasticsearch.
![Diagram of mutual TLS connection between Fleet Server and Elasticsearch](https://www.elastic.co/docs/reference/fleet/images/tls-overview-mutual-fs-es.png)

You can also configure mutual TLS for Fleet Server and Elastic Agent [using a proxy](/docs/reference/fleet/mutual-tls#mutual-tls-cloud-proxy).

### Relationship between components in a mutual TLS connection

![Diagram of mutual TLS connection between components](https://www.elastic.co/docs/reference/fleet/images/tls-overview-mutual-all.jpg)


## Configure TLS/mTLS settings in the Fleet UI

<applies-to>
  - Elastic Stack: Generally available since 9.1
</applies-to>

In self-managed and Elastic Cloud Hosted deployments, you can configure TLS and mutual TLS (mTLS) for Fleet Server and outputs in the Fleet UI.
<note applies-to="Elastic Cloud Serverless: Generally available">
  On Serverless, the Fleet Server settings are managed, but you can still configure TLS/mTLS for your outputs.
</note>


### Fleet Server SSL options

<applies-to>
  - Elastic Cloud Serverless: Unavailable
</applies-to>

To access these settings:
1. In **Kibana**, go to **Management > Fleet > Settings**.
2. Under **Fleet Server hosts**, select **Add host** or edit an existing host.
3. Expand the **SSL options** or **Authentication** section.

The following table shows the available UI fields and their CLI equivalents:

| **UI Field**                          | **CLI Flag**                 | **Purpose**                                                          |
|---------------------------------------|------------------------------|----------------------------------------------------------------------|
| Server SSL certificate authorities    | `--certificate-authorities`  | CA to validate agent certificates (Fleet Server authenticates agent) |
| Client SSL certificate                | `--fleet-server-cert`        | TLS certificate Fleet Server presents to agent (agent validates it)  |
| Client SSL certificate key            | `--fleet-server-cert-key`    | Key paired with the Fleet Server client certificate                  |
| Elasticsearch certificate authorities | `--fleet-server-es-ca`       | CA Fleet Server uses to validate Elasticsearch cert                  |
| SSL certificate for Elasticsearch     | `--fleet-server-es-cert`     | Fleet Server’s mTLS certificate for Elasticsearch                    |
| SSL certificate key for Elasticsearch | `--fleet-server-es-cert-key` | Key paired with the Fleet Server’s Elasticsearch certificate         |
| Enable client authentication          | `--fleet-server-client-auth` | Require agents to present client certificates (mTLS only)            |


### Output SSL options

To access these settings:
1. In **Kibana**, go to **Management > Fleet > Settings**.
2. Under **Outputs**, select **Add output** or edit an existing output.
3. Expand the **SSL options** or **Authentication** section.

These apply to Elasticsearch and Remote Elasticsearch only, and are only necessary when setting up an mTLS connection:

| **UI Field**                       | **CLI Flag**                | **Purpose**                                                      |
|------------------------------------|-----------------------------|------------------------------------------------------------------|
| Server SSL certificate authorities | `--certificate-authorities` | CA the agent uses to verify the output’s TLS certificate         |
| Client SSL certificate             | `--elastic-agent-cert`      | Certificate used by agent to authenticate with output (for mTLS) |
| Client SSL certificate key         | `--elastic-agent-cert-key`  | Key paired with agent mTLS certificate                           |

<warning>
  Editing SSL or proxy settings for an existing Fleet Server might cause agents to lose connectivity. After changing client certificate settings, you might need to re-enroll the affected agents.
</warning>