﻿---
title: Structure of a config file
description: The elastic-agent.yml policy file contains all of the settings that determine how Elastic Agent runs. The most important and commonly used settings are...
url: https://www.elastic.co/docs/reference/fleet/structure-config-file
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Structure of a config file
The `elastic-agent.yml` policy file contains all of the settings that determine how Elastic Agent runs. The most important and commonly used settings are described here, including input and output options, providers used for variables and conditional output, security settings, logging options, enabling of special features, and specifications for Elastic Agent upgrades.
An `elastic-agent.yml` file is modular: You can combine input, output, and all other settings to enable the [Integrations](https://www.elastic.co/docs/reference/integrations) to use with Elastic Agent. Refer to [Create a standalone Elastic Agent policy](https://www.elastic.co/docs/reference/fleet/create-standalone-agent-policy) for the steps to download the settings to use as a starting point, and then refer to the following examples to learn about the available settings:
- [Config file examples](https://www.elastic.co/docs/reference/fleet/config-file-examples)
- [Use standalone Elastic Agent to monitor nginx](https://www.elastic.co/docs/reference/fleet/example-standalone-monitor-nginx).


## Config file components

The following categories include the most common settings used to configure standalone Elastic Agent. Follow each link for more detail and examples.
<definitions>
  <definition term="Inputs">
    Specify how Elastic Agent locates and processes input data.
  </definition>
  <definition term="Providers">
    Specify the key-value pairs used for variable substitution and conditionals in Elastic Agent output.
  </definition>
  <definition term="Outputs">
    Specify where Elastic Agent sends data.
  </definition>
  <definition term="SSL/TLS">
    Configure SSL including SSL protocols and settings for certificates and keys.
  </definition>
  <definition term="Logging">
    Configure the Elastic Agent logging output.
  </definition>
  <definition term="Feature flags">
    Configure any experiemental features in Elastic Agent. These are disabled by default.
  </definition>
  <definition term="Agent download">
    Specify the location of required artifacts and other settings used for Elastic Agent upgrades.
  </definition>
</definitions>