﻿---
title: Start and stop Elastic Agents on edge hosts
description: You can start and stop the Elastic Agent service on the host where it’s running, and it will no longer send data to Elasticsearch. If you’ve stopped the...
url: https://www.elastic.co/docs/reference/fleet/start-stop-elastic-agent
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Start and stop Elastic Agents on edge hosts
You can start and stop the Elastic Agent service on the host where it’s running, and it will no longer send data to Elasticsearch.

## Start Elastic Agent

If you’ve stopped the Elastic Agent service and want to restart it, use the commands that work with your system:
<tab-set>
  <tab-item title="macOS">
    ```shell
    sudo launchctl load /Library/LaunchDaemons/co.elastic.elastic-agent.plist
    ```
  </tab-item>

  <tab-item title="Linux">
    ```shell
    sudo service elastic-agent start
    ```
  </tab-item>

  <tab-item title="Windows">
    ```shell
    Start-Service Elastic Agent
    ```
  </tab-item>

  <tab-item title="DEB">
    The DEB package includes a service unit for Linux systems with systemd. On these systems, you can manage Elastic Agent by using the usual systemd commands.Use `systemctl` to start the agent:
    ```shell
    sudo systemctl start elastic-agent
    ```
    Otherwise, use:
    ```shell
    sudo service elastic-agent start
    ```
  </tab-item>

  <tab-item title="RPM">
    The RPM package includes a service unit for Linux systems with systemd. On these systems, you can manage Elastic Agent by using the usual systemd commands.Use `systemctl` to start the agent:
    ```shell
    sudo systemctl start elastic-agent
    ```
    Otherwise, use:
    ```shell
    sudo service elastic-agent start
    ```
  </tab-item>
</tab-set>


## Stop Elastic Agent

To stop Elastic Agent and its related executables, stop the Elastic Agent service. Use the commands that work with your system:
<tab-set>
  <tab-item title="macOS">
    ```shell
    sudo launchctl unload /Library/LaunchDaemons/co.elastic.elastic-agent.plist
    ```

    <note>
      Elastic Agent will restart automatically if the system is rebooted.
    </note>
  </tab-item>

  <tab-item title="Linux">
    ```shell
    sudo service elastic-agent stop
    ```

    <note>
      Elastic Agent will restart automatically if the system is rebooted.
    </note>
  </tab-item>

  <tab-item title="Windows">
    ```shell
    Stop-Service Elastic Agent
    ```
    If necessary, use Task Manager on Windows to stop Elastic Agent. This will kill the `elastic-agent` process and any sub-processes it created (such as Beats).
    <note>
      Elastic Agent will restart automatically if the system is rebooted.
    </note>
  </tab-item>

  <tab-item title="DEB">
    The DEB package includes a service unit for Linux systems with systemd. On these systems, you can manage Elastic Agent by using the usual systemd commands.Use `systemctl` to stop the agent:
    ```shell
    sudo systemctl stop elastic-agent
    ```
    Otherwise, use:
    ```shell
    sudo service elastic-agent stop
    ```

    <note>
      Elastic Agent will restart automatically if the system is rebooted.
    </note>
  </tab-item>

  <tab-item title="RPM">
    The RPM package includes a service unit for Linux systems with systemd. On these systems, you can manage Elastic Agent by using the usual systemd commands.Use `systemctl` to stop the agent:
    ```shell
    sudo systemctl stop elastic-agent
    ```
    Otherwise, use:
    ```shell
    sudo service elastic-agent stop
    ```

    <note>
      Elastic Agent will restart automatically if the system is rebooted.
    </note>
  </tab-item>
</tab-set>