﻿---
title: Set inactivity timeout
description: The inactivity timeout moves Elastic Agents to inactive status after being offline for a set amount of time. Inactive Elastic Agents are still valid Elastic...
url: https://www.elastic.co/docs/reference/fleet/set-inactivity-timeout
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Set inactivity timeout
The inactivity timeout moves Elastic Agents to inactive status after being offline for a set amount of time. Inactive Elastic Agents are still valid Elastic Agents, but are removed from the main Fleet UI allowing you to better manage Elastic Agents and declutter the Fleet UI.
When Fleet Server receives a check-in from an inactive Elastic Agent, it returns to healthy status.
For example, if an employee is on holiday with their laptop off, the Elastic Agent will transition to offline then inactive once the inactivity timeout limit is reached. This prevents the inactive Elastic Agent from cluttering the Fleet UI. When the employee returns, the Elastic Agent checks in and returns to healthy status with valid API keys.
If an Elastic Agent is no longer valid, you can manually [unenroll](https://www.elastic.co/docs/reference/fleet/unenroll-elastic-agent) inactive Elastic Agents to revoke the API keys. Unenrolled agents need to be re-enrolled to be operational again.
For more on Elastic Agent statuses, see [view agent status](/docs/reference/fleet/monitor-elastic-agent#view-agent-status).

## Set the inactivity timeout

Set the inactivity timeout in the Elastic Agent policy to the amount of time after which you want an offline Elastic Agent to become inactive.
To set the inactivity timeout:
1. In **Fleet**, select **Agent policies**.
2. Click the policy name, then click **Settings**.
3. In the **Inactivity timeout** field, enter a value in seconds. The default value is 1209600 seconds or two weeks.