﻿---
title: Run Elastic Agent Standalone on Kubernetes
description: kubectl installed.Elasticsearch for storing and searching your data, and Kibana for visualizing and managing it.kube-state-metrics.You need to deploy...
url: https://www.elastic.co/docs/reference/fleet/running-on-kubernetes-standalone
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Run Elastic Agent Standalone on Kubernetes
## What you need

- [kubectl installed](https://kubernetes.io/docs/tasks/tools/).
- Elasticsearch for storing and searching your data, and Kibana for visualizing and managing it.
  <applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
  To get started quickly, spin up an [Elastic Cloud Hosted](https://www.elastic.co/cloud/elasticsearch-service) deployment. Elastic Cloud Hosted is available on AWS, GCP, and Azure. [Try it out for free](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
  </applies-item>

  <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
  To install and run Elasticsearch and Kibana, see [Installing the Elastic Stack](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch).
  </applies-item>
  </applies-switch>
- `kube-state-metrics`.
  You need to deploy `kube-state-metrics` to get the metrics about the state of the objects on the cluster (see the [Kubernetes deployment](https://github.com/kubernetes/kube-state-metrics#kubernetes-deployment) docs). You can do that by first downloading the project:
  ```sh
  gh repo clone kubernetes/kube-state-metrics
  ```
  And then deploying it:
  ```sh
  kubectl apply -k kube-state-metrics
  ```
  <warning>
  On managed Kubernetes solutions, such as AKS, GKE or EKS, Elastic Agent does not have the required permissions to collect metrics from [Kubernetes control plane](https://kubernetes.io/docs/concepts/overview/components/#control-plane-components) components, like `kube-scheduler` and `kube-controller-manager`. Audit logs are only available on Kubernetes control plane nodes as well, and hence cannot be collected by Elastic Agent. Refer [here](https://www.elastic.co/docs/reference/integrations/kubernetes/kube-scheduler) and [here](https://www.elastic.co/docs/reference/integrations/kubernetes/kube-controller-manager) to find more information. For more information about specific cloud providers, refer to [Run Elastic Agent on Azure AKS managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-aks-managed-by-fleet), [Run Elastic Agent on GKE managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-gke-managed-by-fleet) and [Run Elastic Agent on Amazon EKS managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-eks-managed-by-fleet)
  </warning>


### Step 1: Download the Elastic Agent manifest

<note>
  You can find Elastic Agent Docker images [here](https://www.docker.elastic.co/r/elastic-agent/elastic-agent).
</note>

Download the manifest file:
```sh
curl -L -O https://raw.githubusercontent.com/elastic/elastic-agent/v9.0.0/deploy/kubernetes/elastic-agent-standalone-kubernetes.yaml
```

<note>
  You might need to adjust [resource limits](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) of the Elastic Agent container in the manifest. Container resource usage depends on the number of data streams and the environment size.
</note>

This manifest includes the Kubernetes integration to collect Kubernetes metrics and System integration to collect system level metrics and logs from nodes.
The Elastic Agent is deployed as a [DaemonSet](https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/) to ensure that there is a running instance on each node of the cluster. These instances are used to retrieve most metrics from the host, such as system metrics, Docker stats, and metrics from all the services running on top of Kubernetes. These metrics are accessed through the deployed `kube-state-metrics`. Notice that everything is deployed under the `kube-system` namespace by default. To change the namespace, modify the manifest file.
Moreover, one of the Pods in the DaemonSet will constantly hold a *leader lock* which makes it responsible for handling cluster-wide monitoring. You can find more information about leader election configuration options at [leader election provider](https://www.elastic.co/docs/reference/fleet/kubernetes_leaderelection-provider). The leader pod will retrieve metrics that are unique for the whole cluster, such as Kubernetes events or [kube-state-metrics](https://github.com/kubernetes/kube-state-metrics). We make sure that these metrics are retrieved from the leader pod by applying the following [condition](https://www.elastic.co/docs/reference/fleet/elastic-agent-kubernetes-autodiscovery) in the manifest, before declaring the data streams with these metricsets:
```yaml
...
inputs:
  - id: kubernetes-cluster-metrics
    condition: ${kubernetes_leaderelection.leader} == true
    type: kubernetes/metrics
    # metricsets with the state_ prefix and the metricset event
...
```

For Kubernetes Security Posture Management (KSPM) purposes, the Elastic Agent requires read access to various types of Kubernetes resources, node processes, and files. To achieve this, read permissions are granted to the Elastic Agent for the necessary resources, and volumes from the hosting node’s file system are mounted to allow accessibility to the Elastic Agent pods.
<tip>
  The size and the number of nodes in a Kubernetes cluster can be large at times, and in such a case the Pod that will be collecting cluster level metrics might require more runtime resources than you would like to dedicate to all of the pods in the DaemonSet. The leader which is collecting the cluster wide metrics may face performance issues due to resource limitations if under-resourced. In this case users might consider avoiding the use of a single DaemonSet with the leader election strategy and instead run a dedicated standalone Elastic Agent instance for collecting cluster wide metrics using a Deployment in addition to the DaemonSet to collect metrics for each node. Then both the Deployment and the DaemonSet can be resourced independently and appropriately. For more information check the [Scaling Elastic Agent on Kubernetes](https://www.elastic.co/docs/reference/fleet/scaling-on-kubernetes) page.
</tip>


### Step 2: Connect to the Elastic Stack

Set the Elasticsearch settings before deploying the manifest:
```yaml
- name: ES_USERNAME
  value: "elastic" 
- name: ES_PASSWORD
  value: "passpassMyStr0ngP@ss" 
- name: ES_HOST
  value: "https://somesuperhostiduuid.europe-west1.gcp.cloud.es.io:9243" 
```

Refer to [Environment variables](https://www.elastic.co/docs/reference/fleet/agent-environment-variables) for all available options.

### Step 3: Configure tolerations

Kubernetes control plane nodes can use [taints](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/) to limit the workloads that can run on them. The manifest for standalone Elastic Agent defines tolerations to run on these. Agents running on control plane nodes collect metrics from the control plane components (scheduler, controller manager) of Kubernetes. To disable Elastic Agent from running on control plane nodes, remove the following part of the DaemonSet spec:
```yaml
spec:
  # Tolerations are needed to run Elastic Agent on Kubernetes control-plane nodes.
  # Agents running on control-plane nodes collect metrics from the control plane components (scheduler, controller manager) of Kubernetes
  tolerations:
    - key: node-role.kubernetes.io/control-plane
      effect: NoSchedule
    - key: node-role.kubernetes.io/master
      effect: NoSchedule
```

Both these two tolerations do the same, but `node-role.kubernetes.io/master` is [deprecated as of Kubernetes version v1.25](https://kubernetes.io/docs/reference/labels-annotations-taints/#node-role-kubernetes-io-master-taint).

### Step 4: Deploy the Elastic Agent

To deploy Elastic Agent to Kubernetes, run:
```sh
kubectl create -f elastic-agent-standalone-kubernetes.yaml
```

To check the status, run:
```sh
$ kubectl -n kube-system get pods -l app=elastic-agent
NAME                            READY   STATUS    RESTARTS   AGE
elastic-agent-4665d             1/1     Running   0          81m
elastic-agent-9f466c4b5-l8cm8   1/1     Running   0          81m
elastic-agent-fj2z9             1/1     Running   0          81m
elastic-agent-hs4pb             1/1     Running   0          81m
```

<admonition title="Running Elastic Agent on a read-only file system">
  If you’d like to run Elastic Agent on Kubernetes on a read-only file system, you can do so by specifying the `readOnlyRootFilesystem` option.
</admonition>


### Step 5: View your data in Kibana

1. Launch Kibana:
   <applies-switch>
   <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
   1. [Log in](https://cloud.elastic.co/) to your Elastic Cloud account.
   2. Navigate to the Kibana endpoint in your deployment.
   </applies-item>

   <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
   Point your browser to [http://localhost:5601](http://localhost:5601), replacing `localhost` with the name of the Kibana host.
   </applies-item>
   </applies-switch>
2. You can see data flowing in by going to **Analytics → Discover** and selecting the index `metrics-*`, or even more specific, `metrics-kubernetes.*`. If you can’t see these indexes, [create a data view](https://www.elastic.co/docs/explore-analyze/find-and-organize/data-views) for them.
3. You can see predefined dashboards by selecting **Analytics→Dashboard**, or by [installing assets through an integration](https://www.elastic.co/docs/reference/fleet/view-integration-assets).


## Red Hat OpenShift configuration

If you are using Red Hat OpenShift, you need to specify additional settings in the manifest file and enable the container to run as privileged.
1. In the manifest file, modify the `agent-node-datastreams` ConfigMap and adjust inputs:
   - `kubernetes-cluster-metrics` input:
  - If `https` is used to access `kube-state-metrics`, add the following settings to all `kubernetes.state_*` datasets:
  ```yaml
    bearer_token_file: /var/run/secrets/kubernetes.io/serviceaccount/token
    ssl.certificate_authorities:
      - /var/run/secrets/kubernetes.io/serviceaccount/service-ca.crt
  ```
- `kubernetes-node-metrics` input:
  - Change the `kubernetes.controllermanager` data stream condition to:
  ```yaml
  condition: ${kubernetes.labels.app} == 'kube-controller-manager'
  ```
- Change the `kubernetes.scheduler` data stream condition to:
  ```yaml
  condition: ${kubernetes.labels.app} == 'openshift-kube-scheduler'
  ```
- The `kubernetes.proxy` data stream configuration should look like:
  ```yaml
  - data_stream:
      dataset: kubernetes.proxy
      type: metrics
    metricsets:
      - proxy
    hosts:
      - 'localhost:29101'
    period: 10s
  ```
- Add the following settings to all data streams that connect to `https://${env.NODE_NAME}:10250`:
  ```yaml
    bearer_token_file: /var/run/secrets/kubernetes.io/serviceaccount/token
    ssl.certificate_authorities:
      - /path/to/ca-bundle.crt
  ```
  <note>
  `ca-bundle.crt` can be any CA bundle that contains the issuer of the certificate used in the Kubelet API. According to each specific installation of OpenShift this can be found either in `secrets` or in `configmaps`. In some installations it can be available as part of the service account secret, in `/var/run/secrets/kubernetes.io/serviceaccount/service-ca.crt`. When using the [OpenShift installer](https://github.com/openshift/installer/blob/master/docs/user/gcp/install.md) for GCP, mount the following `configmap` in the elastic-agent pod and use `ca-bundle.crt` in `ssl.certificate_authorities`:
  </note>
  ```shell
  Name:         kubelet-serving-ca
  Namespace:    openshift-kube-apiserver
  Labels:       <none>
  Annotations:  <none>

  Data
  ====
  ca-bundle.crt:
  ```
2. Grant the `elastic-agent` service account access to the privileged SCC:
   ```shell
   oc adm policy add-scc-to-user privileged system:serviceaccount:kube-system:elastic-agent
   ```
   This command enables the container to be privileged as an administrator for OpenShift.
3. If the namespace where elastic-agent is running has the `"openshift.io/node-selector"` annotation set, elastic-agent might not run on all nodes. In this case consider overriding the node selector for the namespace to allow scheduling on any node:
   ```shell
   oc patch namespace kube-system -p \
   '{"metadata": {"annotations": {"openshift.io/node-selector": ""}}}'
   ```
   This command sets the node selector for the project to an empty string.


### Autodiscover targeted Pods

Refer to [Kubernetes autodiscovery with Elastic Agent](https://www.elastic.co/docs/reference/fleet/elastic-agent-kubernetes-autodiscovery) for more information.

## Logging considerations

Altering the default logging in a standalone container requires additional considerations. By default the Elastic Agent logs to `stderr` and an internal destination so that diagnostics can be properly collected.
To log to a custom filepath, make these changes to the manifest file:
- Elastic Agent logging must be configured in the configmap for `agent.yml`:
  ```yaml
  agent:
    logging:
      level: info
      to_files: true 
      to_stderr: true
    files:
        path: ${LOGS_PATH}
  ```
- The `LOGS_PATH` environment variable must be defined as a part of the Daeomonset's container specification.
- The default DaemonSet container args must be changed to remove the `-e` option:
  ```yaml
  args: ["-c", "/etc/elastic-agent/agent.yml"]
  ```