﻿---
title: Run Elastic Agent on GKE managed by Fleet
description: Follow the steps to run the Elastic Agent on Run Elastic Agent on Kubernetes managed by Fleet page. On managed Kubernetes solutions like GKE, Elastic...
url: https://www.elastic.co/docs/reference/fleet/running-on-gke-managed-by-fleet
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Run Elastic Agent on GKE managed by Fleet
Follow the steps to run the Elastic Agent on [Run Elastic Agent on Kubernetes managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-kubernetes-managed-by-fleet) page.

### Important notes:

On managed Kubernetes solutions like GKE, Elastic Agent has no access to several data sources. Find below the list of the non-available data:
1. Metrics from [Kubernetes control plane](https://kubernetes.io/docs/concepts/overview/components/#control-plane-components) components are not available. Consequently, metrics are not available for `kube-scheduler` and `kube-controller-manager` components. In this regard, the respective **dashboards** will not be populated with data.
2. **Audit logs** are available only on Kubernetes master nodes as well, hence cannot be collected by Elastic Agent.


## Autopilot GKE

Although autopilot removes many administration challenges (such as workload management or deployment automation of kubernetes clusters), it additionally restricts access to specific namespaces (that is, `kube-system`) and host paths which is the reason that default Elastic Agent manifests would not work.
Specific manifests are provided to cover [Autopilot environments](https://github.com/elastic/elastic-agent/blob/main/docs/elastic-agent-gke-autopilot.md).
`kube-state-metrics` also must be installed to another namespace rather than the `default` as access to `kube-system` is not allowed.

## Additonal Resources:

- Blog [Using Elastic to observe GKE Autopilot clusters](https://www.elastic.co/blog/elastic-observe-gke-autopilot-clusters)
- Elastic speakers webinar: ["Get full Kubernetes visibility into GKE Autopilot with Elastic Observability"](https://www.elastic.co/virtual-events/get-full-kubernetes-visibility-into-gke-autopilot-with-elastic-observability)