﻿---
title: Configure Elastic Agent Add-On on Amazon EKS
description: Amazon EKS (Elastic Kubernetes Service) is a managed service that allows you to use Kubernetes on AWS without installing and operating your Kubernetes...
url: https://www.elastic.co/docs/reference/fleet/running-on-eks-managed-by-fleet
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure Elastic Agent Add-On on Amazon EKS
Amazon EKS (Elastic Kubernetes Service) is a managed service that allows you to use Kubernetes on AWS without installing and operating your Kubernetes infrastructure.
Follow these steps to configure the Elastic Agent Add-On on Amazon EKS.

## What you need

- An existing Amazon EKS cluster. To deploy one, see [Create an Amazon EKS cluster](https://docs.aws.amazon.com/eks/latest/userguide/create-cluster.html).
- Elasticsearch for storing and searching your data, and Kibana for visualizing and managing it.
  <applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
  To get started quickly, spin up an [Elastic Cloud Hosted](https://www.elastic.co/cloud/elasticsearch-service) deployment. Elastic Cloud Hosted is available on AWS, GCP, and Azure. [Try it out for free](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
  </applies-item>

  <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
  To install and run Elasticsearch and Kibana, see [Installing the Elastic Stack](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch).
  </applies-item>
  </applies-switch>


### Step 1: Create the Node group

You can create a managed node group with either of the following:
- [eksctl](https://docs.aws.amazon.com/eks/latest/userguide/create-managed-node-group.html#eksctl_create_managed_nodegroup)
- [AWS Management Console](https://docs.aws.amazon.com/eks/latest/userguide/create-managed-node-group.html#console_create_managed_nodegroup)


### Step 2: Select the Elastic Agent Add-On

To see all available add-ons, check the [AWS Add-ons](https://docs.aws.amazon.com/eks/latest/userguide/workloads-add-ons-available-eks.html). You can also view the most current list of available add-ons using `eksctl`, the AWS Management Console, or the AWS CLI.

### Step 3: Configure Elastic Agent Add-On

1. Choose the version of Elastic Agent desired.
2. Get the URL and enrollment token from the cluster the Elastic Agent needs to register to.
3. From the Elastic Agent EKS add-on, go to **Configuration values** to enter the relevant URL and token values from your cluster.

```
agent:
	    fleet:
            enabled: true
            url: <insert url from onboarding>
            token: <insert enrollment token from onboarding>
```

Make sure  the configuration override is selected in case there are conflicts.

### Step 4: Review and create

Review the data and add the Elastic Agent EKS add-on to your cluster.
Once created, you can see the Elastic Agent Add-on is **Active** on the AWS EKS console.
Elastic Agent runs as a daemonset, so it is present on each node.

### Step 5: View your data in Kibana

When the Elastic Agent is Active, it appears in Fleet and its configuration is downloaded.
1. Launch Kibana:
   <applies-switch>
   <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
   1. [Log in](https://cloud.elastic.co/) to your Elastic Cloud account.
   2. Navigate to the Kibana endpoint in your deployment.
   </applies-item>

   <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
   Point your browser to [http://localhost:5601](http://localhost:5601), replacing `localhost` with the name of the Kibana host.
   </applies-item>
   </applies-switch>
2. To check if your Elastic Agent is enrolled in Fleet, go to **Management → Fleet → Agents**.

![Elastic Agents Fleet page](https://www.elastic.co/docs/reference/fleet/images/elastic-agent-fleet.png)


## Important notes:

On managed Kubernetes solutions like EKS, Elastic Agent has no access to several data sources. Find below the list of the non available data:
1. Metrics from [Kubernetes control plane](https://kubernetes.io/docs/concepts/overview/components/#control-plane-components) components are not available. Consequently metrics are not available for `kube-scheduler` and `kube-controller-manager` components. In this regard, the respective **dashboards** will not be populated with data.
2. **Audit logs** are available only on Kubernetes master nodes as well, hence cannot be collected by Elastic Agent.
3. Fields `orchestrator.cluster.name` and `orchestrator.cluster.url` are not populated. `orchestrator.cluster.name` field is used as a cluster selector for default Kubernetes dashboards, shipped with [Kubernetes integration](https://www.elastic.co/docs/reference/integrations/kubernetes).
   In this regard, you can use [`add_fields` processor](https://www.elastic.co/docs/reference/beats/filebeat/add-fields) to add `orchestrator.cluster.name` and `orchestrator.cluster.url` fields for each [Kubernetes integration](https://www.elastic.co/docs/reference/integrations/kubernetes)'s component:
   ```yaml
   - add_fields:
       target: orchestrator.cluster
       fields:
         name: clusterName
         url: clusterURL
   ```