﻿---
title: Run Elastic Agent on Azure AKS managed by Fleet
description: Follow the steps to run the Elastic Agent on Run Elastic Agent on Kubernetes managed by Fleet page. On managed Kubernetes solutions like AKS, Elastic...
url: https://www.elastic.co/docs/reference/fleet/running-on-aks-managed-by-fleet
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Run Elastic Agent on Azure AKS managed by Fleet
Follow the steps to run the Elastic Agent on [Run Elastic Agent on Kubernetes managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-kubernetes-managed-by-fleet) page.

## Important notes:

On managed Kubernetes solutions like AKS, Elastic Agent has no access to several data sources. Find below the list of the non available data:
1. Metrics from [Kubernetes control plane](https://kubernetes.io/docs/concepts/overview/components/#control-plane-components) components are not available. Consequently metrics are not available for `kube-scheduler` and `kube-controller-manager` components. In this regard, the respective **dashboards** will not be populated with data.
2. **Audit logs** are available only on Kubernetes master nodes as well, hence cannot be collected by Elastic Agent.
3. Fields `orchestrator.cluster.name` and `orchestrator.cluster.url` are not populated. `orchestrator.cluster.name` field is used as a cluster selector for default Kubernetes dashboards, shipped with [Kubernetes integration](https://www.elastic.co/docs/reference/integrations/kubernetes).
   In this regard, you can use [`add_fields` processor](https://www.elastic.co/docs/reference/beats/filebeat/add-fields) to add `orchestrator.cluster.name` and `orchestrator.cluster.url` fields for each [Kubernetes integration](https://www.elastic.co/docs/reference/integrations/kubernetes)'s component:
   ```yaml
   - add_fields:
       target: orchestrator.cluster
       fields:
         name: clusterName
         url: clusterURL
   ```