﻿---
title: Roll back an Elastic Agent integration
description: Roll back an Elastic Agent integration to the previously installed version, restoring the integration policies and configurations of the previous version.
url: https://www.elastic.co/docs/reference/fleet/roll-back-integration
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
---

# Roll back an Elastic Agent integration
<note>
  This feature is available only for certain subscription levels. For more information, refer to [Elastic subscriptions](https://www.elastic.co/subscriptions).
</note>

If you encounter issues after upgrading an integration, you can roll back the integration to the version installed before the upgrade. During the rollback action, the integration package and all associated integration policies and their configurations are automatically restored to the previously installed version.
Consider rolling back an integration if:
- The upgraded integration introduces breaking changes that affect your data collection.
- The new version causes unexpected behavior or errors in your environment.
- You need to revert to a previous version for compatibility reasons.

<note>
  By default, the rollback action is available for 7 days following the integration upgrade. After the rollback window expires, you can no longer roll back the integration to the previously installed version.You can [configure the rollback time-to-live (TTL)](#configure-rollback-ttl) in Elastic Cloud Hosted or self-managed deployments.
</note>


## Requirements

To successfully roll back an integration, you must have access to all of its integration policies across **all spaces**. If you don't have access to the related spaces, the rollback action will not succeed.

## Roll back an integration

1. In Kibana, go to **Integrations** > **Installed integrations**.
2. Select the integration you want to roll back, then open the integration's **Settings** tab.
3. Click **Rollback <integration>**.
   If the button is disabled for an integration, this may indicate:
   - The 7-day rollback window has expired.
- You don't have access to all integration policies across all spaces.
- No previous version is available to roll back to.
- The integration was never upgraded.
- The integration is not installed from the Elastic Package Registry.
4. In the confirmation window, click **Rollback integration**. A confirmation appears if the rollback is successful.

After the rollback of the integration is complete, the associated integration policies, their configurations and related assets are restored to the integration's previous version.
<tip>
  You can also roll back an integration from **Integrations** > **Installed integrations**:
  1. Click the actions button at the end of the integration's row.
  2. Select **Rollback integration**, then confirm the action.
</tip>

<note>
  The automatic upgrade of rolled back integrations is disabled until the integrations are manually upgraded.
</note>


## Configure the rollback TTL

The default duration of the rollback window is 7 days. To configure the rollback TTL duration, add the `xpack.fleet.integrationRollbackTTL` setting in the user settings of your Elastic Cloud Hosted deployment or in the `kibana.yml` configuration file of your self-managed deployment.
For example, to extend the rollback window to 14 days, set:
```yml
xpack.fleet.integrationRollbackTTL: 14d
```

For more information, refer to [Fleet settings in Kibana](https://www.elastic.co/docs/reference/kibana/configuration-reference/fleet-settings).