﻿---
title: Remove elevated privileges from Elastic Agents
description: Elevated privileges, like root on Linux/macOS or administrator rights on Windows, give agents unrestricted access to system resources. To improve security...
url: https://www.elastic.co/docs/reference/fleet/remove-agent-elevated-privileges
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
---

# Remove elevated privileges from Elastic Agents
Elevated privileges, like root on Linux/macOS or administrator rights on Windows, give agents unrestricted access to system resources. To improve security by limiting this access, remove the agents' root or administrator privileges centrally using the Fleet UI or the Fleet API.
<important>
  Restoring elevated privileges to Elastic Agents through the Fleet UI or API is not currently supported. To grant an agent root or administrator privileges again, you need to either run the `elastic-agent privileged` command directly on the host or reinstall the agent without the `--unprivileged` flag. Refer to [Changing an Elastic Agent's privilege mode](/docs/reference/fleet/elastic-agent-unprivileged#unprivileged-change-mode) for more details.
</important>


## Requirements

To be eligible for elevated privilege removal, Elastic Agents must meet the following requirements:
- The agent must be running Elastic Agent version 9.3.0 or later.
- The agent must not be a Fleet Server agent.
- The agent must not be assigned to an agent policy that contains integrations requiring elevated privileges.

<note>
  Running without root privileges is not supported for Elastic Agents installed using RPM or DEB packages.
</note>


## Remove elevated privileges using the Fleet UI

To remove elevated privileges from one or more Elastic Agents using the Fleet UI:
1. In Kibana, find **Fleet** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select one or more agents for which you want to remove the elevated privileges.
3. Select **Actions** > **Security and removal** > **Remove root access for N agents** where N is the number of agents you've selected. A flyout opens.
4. Review the information in the flyout:
   - A warning is displayed if any of the selected agents do not meet the requirements for privilege removal. To view a list of these agents, select **View hosts**.
- When you proceed, elevated privileges are removed only from the agents that meet all [requirements](#remove-elevated-privileges-requirements). Ineligible agents remain unchanged and continue running with elevated privileges.
5. (Optional) To run the agent as a pre-existing user or as part of a pre-existing group, enter these details:
   - Username
- User group
- User password
   If the user details are not specified, Elastic Agent uses the default unprivileged user (`elastic-agent-user`) or creates it if it doesn't exist.
   <note>
   For agents running on Windows, the password is required when specifying a custom user account.
   </note>
6. To confirm, select **Remove privilege for N agents** where N is the number of agents eligible for privilege removal.

The eligible agents are switched to unprivileged mode. You can monitor the progress on the **Agents** tab. After the operation completes, the agents run as unprivileged users and their privilege mode is updated in the agent details.
<note>
  You can also initiate the privilege removal for a single agent from either of these locations:
  - The action menu at the end of the agent's row on the **Agents** tab
  - The **Actions** menu on the agent's **Agent details** page
  From either location, select **Security and removal** > **Remove root privilege**, then review the information in the flyout and confirm to remove privileges.
</note>


## What happens when you remove elevated privileges

When you remove elevated privileges from an Elastic Agent:
1. **User creation**: If a pre-existing user is not specified, a dedicated unprivileged user (`elastic-agent-user`) is created on the host (unless it already exists).
2. **Service ownership change**: The Elastic Agent service switches to run as the created unprivileged user (`elastic-agent-user`) or a custom pre-existing user (if specified).
3. **File permissions adjustment**: The file permissions are adjusted to allow the unprivileged user to operate the agent.
4. **Data collection continues**: The agent continues to collect data, but it can only access resources that the `elastic-agent-user` or the specified pre-existing user has permission to read.
5. **Integration behavior**: Some integrations or data streams that require root or administrator access may start reporting errors or stop collecting certain data. For more details, refer to [Agent and dashboard behaviors in unprivileged mode](/docs/reference/fleet/elastic-agent-unprivileged#unprivileged-command-behaviors).


## Remove elevated privileges using the Fleet API

You can also remove elevated privileges using the Fleet API. This is useful for automation or when managing multiple agents.
<note>
  You can only use the Fleet API to remove elevated privileges. Restoring elevated privileges through the API is not currently supported.
</note>


### Single agent

To remove elevated privileges from a single agent, use the following API endpoint:
```bash
POST /api/fleet/agent/{agent_id}/privilege_level_change
```

Replace the path parameter `{agent_id}` with the ID of the agent.
For detailed API documentation, including request and response examples, refer to:
- [Change agent privilege level (Kibana Serverless API)](https://www.elastic.co/docs/api/doc/serverless/operation/operation-post-fleet-agents-agentid-privilege-level-change)
- [Change agent privilege level (Kibana API)](https://www.elastic.co/docs/api/doc/kibana/operation/operation-post-fleet-agents-agentid-privilege-level-change)


### Multiple agents

To remove elevated privileges from multiple agents at once, use the bulk API endpoint:
```bash
POST /api/fleet/agents/bulk_privilege_level_change
```

Include the agent IDs in the request body. For example:
```yaml
{
  "agents": ["agent-id-1", "agent-id-2", "agent-id-3"]
}
```

For detailed API documentation, including request and response examples, refer to:
- [Bulk change agent privilege level (Kibana Serverless API)](https://www.elastic.co/docs/api/doc/serverless/operation/operation-post-fleet-agents-bulk-privilege-level-change)
- [Bulk change agent privilege level (Kibana API)](https://www.elastic.co/docs/api/doc/kibana/operation/operation-post-fleet-agents-bulk-privilege-level-change)


## Verify the privilege level change

To verify that root or administrator privileges have been removed from an agent:
1. In Fleet, open the **Agents** tab.
2. Select an agent. The **Agent details** page opens.
3. Check the **Privilege mode** field. If the agent is in unprivileged mode, the field shows **Running as non-root**.

You can also view privilege status across all agents enrolled in a policy:
1. In Fleet, open the **Agent policies** tab.
2. Click the agent policy to view its details.
3. Hover over the agent count to display the number of privileged and unprivileged agents enrolled in the policy.


## Troubleshooting

After removing an agent's elevated privileges, some data sources might become inaccessible. To resolve this:
1. Check the agent logs for permission errors.
2. Grant the `elastic-agent-user` user or `elastic-agent` group read access to the necessary files or directories.
3. Alternatively, add the `elastic-agent-user` to relevant system groups that have the required permissions. Be cautious when granting additional permissions as this might reduce the security benefits of unprivileged mode.

For detailed guidance on resolving specific data collection issues, refer to [Agent and dashboard behaviors in unprivileged mode](/docs/reference/fleet/elastic-agent-unprivileged#unprivileged-command-behaviors).