﻿---
title: Remote Elasticsearch output
description: Remote ES output allows you to send agent data to a remote cluster, keeping data separate and independent from the deployment where you use Fleet.
url: https://www.elastic.co/docs/reference/fleet/remote-elasticsearch-output
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Remote Elasticsearch output
Remote Elasticsearch outputs allow you to send Elastic Agent data to a remote Elasticsearch cluster. This is especially useful for data that you want to keep separate and independent from the deployment where you use Fleet to manage the Elastic Agents.
A remote Elasticsearch cluster supports the same [output settings](https://www.elastic.co/docs/reference/fleet/es-output-settings) as your management Elasticsearch cluster.

## Limitations

These limitations apply to remote Elasticsearch output:
- Fleet Server must be able to reach the remote Elasticsearch cluster with a service token to create API keys for any Elastic Agents that use the remote Elasticsearch output.
- Using a remote Elasticsearch output with a target cluster that has [network security](https://www.elastic.co/docs/deploy-manage/security/network-security) enabled is not currently supported.
- Using Elastic Defend when a remote Elasticsearch output is configured for an Elastic Agent is not currently supported.


## Configuration

To configure a remote Elasticsearch cluster for your Elastic Agent data:
<stepper>
  <step title="">
    In your management Elasticsearch cluster, open Kibana, and search for **Fleet settings** in the search bar. Select **Fleet/Settings** in the results.
  </step>

  <step title="">
    In the **Outputs** section, select **Add output**.
  </step>

  <step title="">
    In the **Add new output** flyout, provide a name for the output, and select **Remote Elasticsearch** as the output type.
  </step>

  <step title="">
    In the **Hosts** field, add the URL that Elastic Agents should use to access the remote Elasticsearch cluster.
    <dropdown title="Find the remote host address of the remote cluster">
      1. In the remote cluster, open Kibana, and search for **Fleet settings** in the search bar. Select **Fleet/Settings** in the results.
      2. In the **Outputs** section, copy the `Hosts` value of the default Elasticsearch output. If the value is not visible in full, edit the default  Elasticsearch output to display the full value.
      3. In your management cluster, paste the value you copied into the **Hosts** field of the remote output configuration.
    </dropdown>
  </step>

  <step title="">
    In the **Service Token** field, add a service token to access the remote cluster.
    <dropdown title="Create a service token to access the remote cluster">
      1. Copy the API request located below the **Service Token** field.
      2. In the remote cluster, open the Kibana menu, then go to **Management** → **Dev Tools** in self-managed deployments, or to **Developer tools** in Elastic Cloud deployments.
      3. Paste the API request in the console, then run it.
      4. Copy the value for the generated service token.
      5. In the management cluster, paste the value you copied into the **Service Token** field of the remote output configuration.
    </dropdown>

    <note>
      To prevent unauthorized access, the Elasticsearch Service Token is stored as a secret value. While secret storage is recommended, you can choose to override this setting, and store the password as plain text in the agent policy definition. Secret storage requires Fleet Server version 8.12 or higher. This setting can also be stored as a secret value or as plain text for preconfigured outputs. To learn more about this option, check [Preconfiguration settings](https://www.elastic.co/docs/reference/kibana/configuration-reference/fleet-settings#_preconfiguration_settings_for_advanced_use_cases).
    </note>
  </step>

  <step title="">
    Choose whether integrations should be automatically synchronized on the remote Elasticsearch cluster. To configure this feature, refer to [Automatic integrations synchronization](https://www.elastic.co/docs/reference/fleet/automatic-integrations-synchronization).
    <note>
      Automatic integrations synchronization is available only for certain subscription levels. For more information, check **Fleet Multi-Cluster support** on the [Elastic subscriptions](https://www.elastic.co/subscriptions) page.
    </note>
  </step>

  <step title="">
    Choose whether the remote output should be the default for agent integrations or for agent monitoring data. When set as the default, Elastic Agents use this output to send data if no other output is set in the [agent policy](https://www.elastic.co/docs/reference/fleet/agent-policy).
  </step>

  <step title="">
    Select the [performance tuning settings](/docs/reference/fleet/es-output-settings#es-output-settings-performance-tuning-settings) to optimize Elastic Agents for throughput, scale, or latency, or leave the default `balanced` setting.
  </step>

  <step title="">
    <applies-to>Elastic Cloud Serverless: Preview</applies-to> <applies-to>Elastic Stack: Preview since 9.2</applies-to>
    Choose whether Elastic Agents using this output should send data to [wired streams](/docs/solutions/observability/streams/streams#streams-wired-streams). Using this feature requires additional steps. For more details, refer to [Ship data to streams > Fleet](/docs/solutions/observability/streams/wired-streams#streams-wired-streams-ship).
  </step>

  <step title="">
    Add any [advanced YAML configuration settings](/docs/reference/fleet/es-output-settings#es-output-settings-yaml-config) that you’d like for the remote output.
  </step>

  <step title="">
    Click **Save and apply settings**.
  </step>
</stepper>


## Using the remote Elasticsearch output

After the output is created, you can update an Elastic Agent policy to use the new output, and send data to the remote Elasticsearch cluster:
1. In the management cluster, go to **Fleet**, then open the **Agent policies** tab.
2. Click the agent policy you want to update, then click **Settings**.
3. To send integrations data, set the **Output for integrations** option to use the output that you configured in the previous steps.
4. To send Elastic Agent monitoring data, set the **Output for agent monitoring** option to use the output that you configured in the previous steps.
5. Click **Save changes**.

The remote Elasticsearch output is now configured for the remote cluster.
If you choose not to synchronize integrations automatically, you need to make sure that for any integrations that are [added to your Elastic Agent policy](https://www.elastic.co/docs/reference/fleet/add-integration-to-policy), the integration assets are also installed on the remote Elasticsearch cluster. For detailed steps on this process, refer to [Install and uninstall Elastic Agent integration assets](https://www.elastic.co/docs/reference/fleet/install-uninstall-integration-assets).
<note>
  When you use a remote Elasticsearch output, Fleet Server performs a test to ensure connectivity to the remote cluster. The result of that connectivity test is used to report whether the remote output is healthy or unhealthy, and is displayed on the **Fleet** → **Settings** → **Outputs** page, in the **Status** column.In some cases, the remote Elasticsearch output used for Elastic Agent data can be reached by the Elastic Agents but not by Fleet Server. This will result in the unhealthy status of the output and an `Unable to connect` error on the UI. To generate API keys for Elastic Agents, Fleet Server requires connectivity to the remote cluster.
</note>