﻿---
title: Rate limit the flow of events
description: The rate_limit processor limits the throughput of events based on the specified configuration. In the current implementation, rate-limited events are...
url: https://www.elastic.co/docs/reference/fleet/rate_limit-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Rate limit the flow of events
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The `rate_limit` processor limits the throughput of events based on the specified configuration.
In the current implementation, rate-limited events are dropped. Future implementations may allow rate-limited events to be handled differently.

## Examples

```yaml
- rate_limit:
   limit: "10000/m"
```

```yaml
- rate_limit:
   fields:
   - "cloudfoundry.org.name"
   limit: "400/s"
```

```yaml
- if.equals.cloudfoundry.org.name: "acme"
  then:
  - rate_limit:
      limit: "500/s"
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that your processor configurations cannot refer to fields that are created by ingest pipelines or Logstash. For more limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name     | Required | Default | Description                                                                                                            |
|----------|----------|---------|------------------------------------------------------------------------------------------------------------------------|
| `limit`  | Yes      |         | The rate limit. Supported time units for the rate are `s` (per second), `m` (per minute), and `h` (per hour).          |
| `fields` | No       |         | List of fields. The rate limit will be applied to each distinct value derived by combining the values of these fields. |