﻿---
title: Elastic Agent providers
description: Providers supply key-value pairs for variable substitution and conditional logic. They define dynamic values that Elastic Agent uses when building configurations...
url: https://www.elastic.co/docs/reference/fleet/providers
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent providers
Providers supply key-value pairs for variable substitution and conditional logic. They define dynamic values that Elastic Agent uses when building configurations.
Elastic Agent uses two kinds of providers: [context providers](#context-providers) and [dynamic providers](#dynamic-providers). Each provider’s keys are automatically grouped under the provider name in the Elastic Agent context. For example, if the `foo` provider supplies `{"key1": "value1", "key2": "value2"}`, Elastic Agent stores these key-value pairs as `{"foo": {"key1": "value1", "key2": "value2"}}`. You can then reference the values using the `${foo.key1}` and `${foo.key2}` variables.
How you can configure and use Elastic Agent providers depends on whether you're running a standalone or a Fleet-managed Elastic Agent. For more information, refer to:
- [Configure providers on standalone Elastic Agent](#configure-providers-standalone-agent)
- [Using providers on Fleet-managed Elastic Agent](#using-providers-fleet-managed-agent)


## Provider types

Elastic Agent supports two types of providers: [context providers](#context-providers) and [dynamic providers](#dynamic-providers).

### Context providers

Context providers supply a single key-value mapping that describes the current environment where Elastic Agent is running, such as agent information (ID, version), host information (hostname, IP addresses), and environment information (environment variables). When the underlying context changes, Elastic Agent updates this mapping and re-evaluates the configuration.
To ensure consistency and clarity across documentation and projects, context providers use the Elastic Common Schema (ECS) naming conventions.
Elastic Agent supports the following context providers:
- [Local provider](https://www.elastic.co/docs/reference/fleet/local-provider) - Provides custom keys to use as variables.
- [Agent provider](https://www.elastic.co/docs/reference/fleet/agent-provider) - Provides information about the Elastic Agent such as ID, version, and build details.
- [Host provider](https://www.elastic.co/docs/reference/fleet/host-provider) - Provides information about the current host such as hostname, IP addresses, platform, and architecture.
- [Env provider](https://www.elastic.co/docs/reference/fleet/env-provider) - Provides access to environment variables as key-value pairs.
- [Kubernetes Secrets provider](https://www.elastic.co/docs/reference/fleet/kubernetes_secrets-provider) - Provides access to the Kubernetes Secrets API.
- [Kubernetes LeaderElection provider](https://www.elastic.co/docs/reference/fleet/kubernetes_leaderelection-provider) - Enables leader election between Elastic Agent instances running on Kubernetes to ensure only one agent holds the leader lock.


### Dynamic providers

Dynamic providers supply multiple key-value mappings where each mapping represents a separate item or resource (such as a container or pod). When rendering configurations, Elastic Agent combines each mapping with the values from context providers, and for every mapping that matches a configuration template or condition, it creates a separate configuration instance and substitutes any dynamic variables (for example, `${docker.container.id}` or `${kubernetes.pod.ip}`) with values from that mapping. This allows Elastic Agent to automatically add, update, or remove inputs as your environment changes.
Elastic Agent supports the following dynamic providers:
- [Local dynamic provider](https://www.elastic.co/docs/reference/fleet/local-dynamic-provider) - Defines multiple key-value pairs to generate multiple configurations.
- [Docker provider](https://www.elastic.co/docs/reference/fleet/docker-provider) - Provides Docker container metadata such as ID, name, image, and labels.
- [Kubernetes provider](https://www.elastic.co/docs/reference/fleet/kubernetes-provider) - Provides metadata from Kubernetes resources such as pods, nodes, and services.


## Configure providers on standalone Elastic Agent

On standalone Elastic Agent, providers can be configured through the top-level `providers` key in the `elastic-agent.yml` configuration file. All registered providers are enabled by default, but Elastic Agent runs them only if they are referenced in the configuration file or in an Elastic Agent policy. Disabled providers are not run even if they are referenced. If a provider cannot connect, no mappings are produced.
You can enable, disable, and configure provider settings as needed. All providers are prefixed without name collisions. In the configuration, the name of the provider is in the key.
The following example shows two providers (`local` and `local_dynamic`) that supply custom keys on a standalone Elastic Agent:
```yaml
providers:
  local:
    vars:
      foo: bar
  local_dynamic:
    items:
      - vars:
          item: key1
      - vars:
          item: key2
      - vars:
          item: key3
```

If a provider is referenced in an Elastic Agent policy, it is turned on automatically unless it's explicitly disabled in the `elastic-agent.yml` configuration file.

### Disable providers

On standalone Elastic Agent, you can disable a specific provider, so it cannot be run even if it is referenced. For example, to disable the Docker provider on a standalone Elastic Agent, set:
```yaml
providers:
  docker:
    enabled: false
```

With this setting, Elastic Agent will not run the Docker provider even if it's referenced in an Elastic Agent policy.
You can also disable all providers by setting `agent.providers.initial_default: false`. The following configuration disables all providers with the exception of the Docker provider, which is run when it's referenced in the policy:
```yaml
agent.providers.initial_default: false
providers:
  docker:
    enabled: true
```


## Using providers on Fleet-managed Elastic Agent

On Fleet-managed Elastic Agent, you can use provider variables in integration policy settings (for example, `${host.name}`, `${env.foo}`, `${agent.id}`), but you cannot add a `providers` configuration block directly through the Fleet UI.
Some providers can be configured on Kubernetes deployments using ConfigMaps. For more details, refer to [Advanced Elastic Agent configuration managed by Fleet](https://www.elastic.co/docs/reference/fleet/advanced-kubernetes-managed-by-fleet).