﻿---
title: Collect OpenTelemetry data with Elastic Agent integrations
description: Fleet supports installing Elastic Agent integration packages for collecting and visualizing OpenTelemetry data such as logs, metrics, and traces.
url: https://www.elastic.co/docs/reference/fleet/otel-integrations
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
---

# Collect OpenTelemetry data with Elastic Agent integrations
Fleet supports installing Elastic Agent integration packages for collecting and visualizing OpenTelemetry (OTel) data such as logs, metrics, and traces.
To display the available OpenTelemetry integration packages:
1. In Kibana, find **Integrations** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select the **OpenTelemetry** category.

<note>
  Some OpenTelemetry integrations are in technical preview and only appear in the list when you enable the setting to show beta integrations.
</note>

There are two types of OpenTelemetry integration packages:
- Input packages which include an OTel Collector configuration.
- Content packages which include Elasticsearch and Kibana assets such as prebuilt dashboards and visualizations.

Unlike Elastic Agent integrations based on the [Elastic Common Schema](https://www.elastic.co/docs/reference/ecs) (ECS), OpenTelemetry input packages use OTel Collector receivers to collect OTel data following [OpenTelemetry semantic conventions](https://opentelemetry.io/docs/specs/semconv).
When OTel data is collected using an OpenTelemetry input package, content packages with assets related to the collected data type are automatically installed if available.
<important>
  OpenTelemetry input packages are used with Fleet and Elastic Agent running in default mode. They cannot be used with an [Elastic Agent running as an EDOT Collector](https://www.elastic.co/docs/reference/fleet/otel-agent) (an agent in `otel` mode).
</important>


## Configure OpenTelemetry input packages

The installation and configuration of OpenTelemetry input packages are similar to those of ECS-based integrations, and allow you to specify the namespace, dataset name, data stream type, and more. For step-by-step instructions, refer to [Add an integration to an Elastic Agent policy](https://www.elastic.co/docs/reference/fleet/add-integration-to-policy).
When the integration policy for the input package is created, Fleet creates a managed index template with an OTel configuration and an index pattern with an `.otel` suffix. The index template uses Fleet component templates for settings and OTel component templates for default mappings. It also includes `@custom` component templates that allow you to [customize your Elasticsearch index](/docs/reference/fleet/data-streams#data-streams-index-templates-edit) similarly to ECS-based integrations.
On the OpenTelemetry input package's **Configs** page, you can view a generated sample configuration, which you can use as a starting point to set up the integration on a standalone Elastic Agent.
This is a partial configuration because it doesn't include an exporter component. For more information on setting up the exporter, refer to [Elasticsearch exporter](https://www.elastic.co/docs/reference/edot-collector/components/elasticsearchexporter).
<note>
  Currently, OpenTelemetry input packages only support sending data using the Elasticsearch output.
</note>

Only Elastic Agents on version 9.2 or later can collect OTel data using OpenTelemetry input packages. OpenTelemetry input packages added to an agent policy do not affect enrolled agents on prior versions.

## Hybrid agent policies

A hybrid agent policy is an agent policy that includes configurations for both ECS-based integrations and OpenTelemetry input packages. This combination lets you leverage the strengths of both data collection methods within a single Elastic Agent configuration, without locking you into a single ingestion model.
A hybrid agent policy allows you to:
- Ingest logs and metrics with ECS-based integrations and leverage their built-in dashboards and alerts
- Collect additional telemetry data using OpenTelemetry Collector components
- Gradually adopt OpenTelemetry standards across your infrastructure
- Maintain centralized management through Fleet

For examples on using a hybrid agent policy to collect telemetry, refer to:
- [Collect NGINX data with OpenTelemetry integrations (Fleet-managed)](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/collect-nginx-data-otel-integration-fleet-managed)
- [Collect NGINX data with OpenTelemetry integrations (standalone)](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/collect-nginx-data-otel-integration-standalone)