﻿---
title: Run Elastic Agent as an EDOT Collector
description: The Elastic Distribution of OpenTelemetry (EDOT) Collector is an open-source agent that can receive, process, and export telemetry data. Elastic Agent...
url: https://www.elastic.co/docs/reference/fleet/otel-agent
products:
  - Elastic Agent
  - Elastic Distribution of OpenTelemetry Collector
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Run Elastic Agent as an EDOT Collector
The [Elastic Distribution of OpenTelemetry (EDOT) Collector](https://www.elastic.co/docs/reference/edot-collector) is an open-source agent that can receive, process, and export telemetry data. Elastic Agent includes an embedded EDOT Collector that allows you to instrument your applications and infrastructure once, and send data to multiple vendors and backends.
When you run Elastic Agent in `otel` mode, it supports the standard OpenTelemetry Collector configuration format that defines a set of receivers, processors, exporters, and connectors. Logs, metrics, and traces can be collected and exported using OpenTelemetry data formats.
For a full overview and steps to configure Elastic Agent in `otel` mode, including a guided onboarding, refer to [Elastic Distributions for OpenTelemetry](https://www.elastic.co/docs/reference/edot-collector). You can also check the [`elastic-agent otel` command](/docs/reference/fleet/agent-command-reference#elastic-agent-otel-command) in the Fleet and Elastic Agent Command reference.
If you have a currently running Elastic Agent you can [transform it to run as an OTel Collector](https://www.elastic.co/docs/reference/fleet/otel-agent-transform).