﻿---
title: Elastic Agent deployment models with mutual TLS
description: Mutual Transport Layer Security (mTLS) provides a higher level of security and trust compared to one-way TLS, where only the server presents a certificate...
url: https://www.elastic.co/docs/reference/fleet/mutual-tls
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent deployment models with mutual TLS
Mutual Transport Layer Security (mTLS) provides a higher level of security and trust compared to one-way TLS, where only the server presents a certificate. It ensures that not only the server is who it claims to be, but the client is also authenticated. This is particularly valuable in scenarios where both parties need to establish trust and validate each other’s identities, such as in secure API communication, web services, or remote authentication.
For a summary of flow by which TLS is established between components using either one-way or mutual TLS, refer to [One-way and mutual TLS certifications flow](https://www.elastic.co/docs/reference/fleet/tls-overview).
- [Overview](#mutual-tls-overview)
- [On-premise deployments](#mutual-tls-on-premise)
- [Fleet Server on Elastic Cloud](#mutual-tls-cloud)
- [Fleet Server on Elastic Cloud using a proxy](#mutual-tls-cloud-proxy)
- [Fleet Server on-premise and Elastic Cloud Hosted](#mutual-tls-on-premise-hosted-es)


## Overview

With mutual TLS the following authentication and certification verification occurs:
- **Client Authentication**: The client presents its digital certificate to the server during the TLS handshake. This certificate is issued by a trusted Certificate Authority (CA) and contains the client’s public key.
- **Server Authentication**: The server also presents its digital certificate to the client, proving its identity and sharing its public key. The server’s certificate is also issued by a trusted CA.
- **Certificate Verification**: Both the client and server verify each other's certificates by checking the digital signatures against the CAs' public key. The client and server need not use the same CA.

Fleet-managed Elastic Agent has two main connections to ensure correct operations:
- Connectivity to Fleet Server (the control plane, to check in, download policies, and similar).
- Connectivity to an Output (the data plane, such as Elasticsearch or Logstash).

In order to bootstrap, Elastic Agent initially must establish a secure connection to the Fleet Server, which can reside on-premises or in Elastic Cloud. This connectivity verification process ensures the agent’s authenticity. Once verified, the agent receives the policy configuration. This policy download equips the agent with the knowledge of the other components it needs to engage with. For instance, it gains insights into the output destinations it should write data to.
When mTLS is required, the secure setup between Elastic Agent, Fleet, and Fleet Server is configured through the following steps:
1. mTLS is enabled.
2. The initial mTLS connection between Elastic Agent and Fleet Server is configured when Elastic Agent is enrolled, using the parameters passed through the `elastic-agent install` or `elastic-agent enroll` command.
3. Once enrollment has completed, Elastic Agent downloads the initial Elastic Agent policy from Fleet Server.
   1. If the Elastic Agent policy contains mTLS configuration settings, those settings will take precedence over those used during enrollment: This includes both the mTLS settings used for connectivity between Elastic Agent and Fleet Server (and the Fleet application in Kibana, for Fleet-managed Elastic Agent), and the settings used between Elastic Agent and it’s specified output.
2. If the Elastic Agent policy does not contain any TLS, mTLS, or proxy configuration settings, these settings will remain as they were specified when Elastic Agent enrolled. The initial TLS, mTLS, or proxy configuration settings can not be removed through the Elastic Agent policy; they can only be updated.

<important>
  When you run Elastic Agent with the Elastic Defend integration, the [TLS certificates](https://en.wikipedia.org/wiki/X.509) used to connect to Fleet Server and Elasticsearch need to be generated using [RSA](https://en.wikipedia.org/wiki/RSA_(cryptosystem)). For a full list of available algorithms to use when configuring TLS or mTLS, see [Configure SSL/TLS for standalone Elastic Agents](https://www.elastic.co/docs/reference/fleet/elastic-agent-ssl-configuration). These settings are available for both standalone and Fleet-managed Elastic Agent.
</important>


## On-premise deployments

<applies-to>
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
</applies-to>

![Diagram of mutual TLS on premise deployment model](https://www.elastic.co/docs/reference/fleet/images/mutual-tls-on-prem.png)

Refer to the steps in [Configure SSL/TLS for self-managed Fleet Servers](https://www.elastic.co/docs/reference/fleet/secure-connections). To configure mutual TLS, include the following additional parameters when you install Elastic Agent and Fleet Server.

### Elastic Agent settings

During Elastic Agent installation on premise use the following options:

|                                       |                                                                                                                                         |
|---------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------|
| `--certificate-authorities`           | List of CA certificates that are trusted when Fleet Server connects to Elastic Agent                                                    |
| `--elastic-agent-cert`                | Elastic Agent certificate to present to Fleet Server during authentication                                                              |
| `--elastic-agent-cert-key`            | Elastic Agent certificate key to present to Fleet Server                                                                                |
| `--elastic-agent-cert-key-passphrase` | The path to the file that contains the passphrase for the mutual TLS private key that Elastic Agent will use to connect to Fleet Server |


### Fleet Server settings

During Fleet Server installation on-premise Fleet Server authenticates with Elasticsearch and Elastic Agents. You can use the following CLI options to facilitate these secure connections:

|                              |                                                                                                                                                  |
|------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------|
| `--fleet-server-es-ca`       | CA to use for the Elasticsearch connection                                                                                                       |
| `--fleet-server-es-cert`     | Fleet Server certificate to present to Elasticsearch                                                                                             |
| `--fleet-server-es-cert-key` | Fleet Server certificate key to present to Elasticsearch                                                                                         |
| `--certificate-authorities`  | List of CA certificates that are trusted when Elastic Agent connects to Fleet Server and when Fleet Server validates the Elastic Agent identity. |
| `--fleet-server-cert`        | Fleet Server certificate to present to Elastic Agents during authentication                                                                      |
| `--fleet-server-cert-key`    | Fleet Server's private certificate key used to decrypt the certificate                                                                           |


### Fleet settings:

In Kibana, navigate to Fleet, open the **Settings** tab, and choose the **Output** that you’d like to configure. In the **Advanced YAML configuration**, add the following settings:

|                               |                                                                                                                                                                                                                                                                                                                                                                                                                              |
|-------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `ssl.certificate_authorities` | List of CA certificates that are trusted when Fleet Server connects to Elastic Agent                                                                                                                                                                                                                                                                                                                                         |
| `ssl.certificate`             | This certificate will be passed down to all the agents that have this output configured in their policy. This certificate is used by the agent when establishing mTLS to the output.You may either apply the full certificate, in which case all the agents get the same certificate OR alternatively point to a local directory on the agent where the certificate resides, if the certificates are to be unique per agent. |
| `ssl.key`                     | This certificate key will be passed down to all the agents that have this output configured in their policy. The certificate key is used to decrypt the SSL certificate.                                                                                                                                                                                                                                                     |

<important>
  Note the following when you specify these SSL settings:
  - The certificate authority, certificate, and certificate key need to be specified as a path to a local file. You cannot specify a directory.
  - You can define multiple CAs or paths to CAs.
  - Only one certificate and certificate key can be defined.
</important>

In the **Advanced YAML configuration** these settings should be added in the following format:
```shell
ssl.certificate_authorities:
  - /path/to/ca
ssl.certificate: /path/to/cert
ssl.key: /path/to/cert_key
```

OR
```shell
ssl.certificate_authorities:
  - /path/to/ca
ssl.certificate: /path/to/cert
ssl.key: /path/to/cert_key
```

![Screen capture of output advanced yaml settings](https://www.elastic.co/docs/reference/fleet/images/mutual-tls-onprem-advanced-yaml.png)


## Fleet Server on Elastic Cloud

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
</applies-to>

In this deployment model, all traffic ingress into Elastic Cloud has its TLS connection terminated at the Elastic Cloud boundary. Since this termination is not handled on a per-tenant basis, a client-specific certificate can NOT be used at this point.
![Diagram of mutual TLS on cloud deployment model](https://www.elastic.co/docs/reference/fleet/images/mutual-tls-cloud.png)

We currently don’t support mTLS in this deployment model. An alternate deployment model is shown below where you can deploy your own secure proxy where TLS connections are terminated.

## Fleet Server on Elastic Cloud using a proxy

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
</applies-to>

In this scenario, where you have access to the proxy, you can configure mTLS between the agent and your proxy.
![Diagram of mutual TLS on cloud deployment model with a proxy](https://www.elastic.co/docs/reference/fleet/images/mutual-tls-cloud-proxy.png)


### Elastic Agent settings

During Elastic Agent installation on premise use the following options:

|                                       |                                                                                                                                             |
|---------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------|
| `--certificate-authorities`           | List of CA certificates that are trusted when Elastic Agent connects to Fleet Server or to the proxy between Elastic Agent and Fleet Server |
| `--elastic-agent-cert`                | Elastic Agent certificate to present  during authentication to Fleet Server or to the proxy between Elastic Agent and Fleet Server          |
| `--elastic-agent-cert-key`            | Elastic Agent's private certificate key used to decrypt the certificate                                                                     |
| `--elastic-agent-cert-key-passphrase` | The path to the file that contains the passphrase for the mutual TLS private key that Elastic Agent will use to connect to Fleet Server     |


## Fleet Server on-premise and Elastic Cloud Hosted

<applies-to>
  - Elastic Cloud Hosted: Generally available
</applies-to>

In some scenarios you may want to deploy Fleet Server on your own premises. In this case, you’re able to provide your own certificates and certificate authority to enable mTLS between Fleet Server and Elastic Agent.
However, as with the [Fleet Server on Elastic Cloud](#mutual-tls-cloud) use case, the data plane TLS connections terminate at the Elastic Cloud boundary. Elastic Cloud is not a multi-tenanted service and therefore can’t provide per-user certificates.
![Diagram of mutual TLS with Fleet Server on premise and Elastic Cloud Hosted deployment model](https://www.elastic.co/docs/reference/fleet/images/mutual-tls-fs-onprem.png)

Similar to the Fleet Server on Elastic Cloud use case, a secure proxy can be placed in such an environment to terminate the TLS connections and satisfy the mTLS requirements.
![Diagram of mutual TLS with Fleet Server on premise and Elastic Cloud Hosted deployment model with a proxy](https://www.elastic.co/docs/reference/fleet/images/mutual-tls-fs-onprem-proxy.png)


### Elastic Agent settings

During Elastic Agent installation on premise use the following options, similar to [Elastic Agent deployment on premises](#mutual-tls-on-premise):

|                                       |                                                                                                                                         |
|---------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------|
| `--certificate-authorities`           | List of CA certificates that are trusted for when Elastic Agent connects to Fleet Server                                                |
| `--elastic-agent-cert`                | Elastic Agent certificate to present to Fleet Server during authentication                                                              |
| `--elastic-agent-cert-key`            | Elastic Agent's private certificate key used to decrypt the certificate                                                                 |
| `--elastic-agent-cert-key-passphrase` | The path to the file that contains the passphrase for the mutual TLS private key that Elastic Agent will use to connect to Fleet Server |


### Fleet Server settings

During Fleet Server installation on-premise use the following options so that Fleet Server can authenticate itself to the agent and then also to the secure proxy server:

|                             |                                                                                                                                          |
|-----------------------------|------------------------------------------------------------------------------------------------------------------------------------------|
| `--fleet-server-es-ca`      | CA to use for the Elasticsearch connection, through secure proxy. This CA is used to authenticate the TLS connection from a secure proxy |
| `--certificate-authorities` | List of CA certificates that are trusted when Elastic Agent connects to Fleet Server                                                     |
| `--fleet-server-cert`       | Fleet Server certificate to present to Elastic Agents during authentication                                                              |
| `--fleet-server-cert-key`   | Fleet Server's private certificate key used to decrypt the certificate                                                                   |


### Fleet settings

This is the same as what’s described for [on premise deployments](#mutual-tls-on-premise). The main difference is that you need to use certificates that are accepted by the secure proxy, as the mTLS is set up between the agent and the secure proxy.