﻿---
title: Migrate from Auditbeat to Elastic Agent
description: Before you begin, read Migrate from Beats to Elastic Agent to learn how to deploy Elastic Agent and install integrations. Then come back to this page...
url: https://www.elastic.co/docs/reference/fleet/migrate-auditbeat-to-agent
products:
  - Auditbeat
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Migrate from Auditbeat to Elastic Agent
Before you begin, read [Migrate from Beats to Elastic Agent](https://www.elastic.co/docs/reference/fleet/migrate-from-beats-to-elastic-agent) to learn how to deploy Elastic Agent and install integrations.
Then come back to this page to learn about the integrations available to replace functionality provided by Auditbeat.

## Compatibility

The integrations that provide replacements for `auditd` and `file_integrity` modules are only available in Elastic Stack version 8.3 and later.

## Replace Auditbeat modules with Elastic Agent integrations

The following table describes the integrations you can use instead of Auditbeat modules and datasets.

| If you use…                                                                                                                                                                      | You can use this instead…                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Notes                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Auditd](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-module-auditd) module                                                                                   | [Auditd Manager](https://www.elastic.co/docs/reference/integrations/auditd_manager) integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | This integration is a direct replacement of the module. You can port rules and configuration to this integration. Starting in Elastic Stack 8.4, you can also set the`immutable` flag in the audit configuration.                                                                                                                                                                                                                                                     |
| [Auditd Logs](https://www.elastic.co/docs/reference/integrations/auditd) integration                                                                                             | Use this integration if you don't need to manage rules. It only parses logs from the audit daemon `auditd`. The events created by this integration are different than the ones created by [Auditd Manager](https://www.elastic.co/docs/reference/integrations/auditd_manager), since the latter merges all related messages in a single event while [Auditd Logs](https://www.elastic.co/docs/reference/integrations/auditd) creates one event per message.                                                                                                                                                                                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [File Integrity](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-module-file_integrity) module                                                                   | [File Integrity Monitoring](https://www.elastic.co/docs/reference/integrations/fim) integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | This integration is a direct replacement of the module. It reports real-time events, but cannot report who made the changes. If you need to track this information, use [Elastic Defend](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend) instead.                                                                                                                                                                     |
| [System](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-module-system) module                                                                                   | It depends…                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | There is not a single integration that collects all this information.                                                                                                                                                                                                                                                                                                                                                                                                 |
| [System.host](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-dataset-system-host) dataset                                                                       | [Osquery](https://www.elastic.co/docs/reference/integrations/osquery) or [Osquery Manager](https://www.elastic.co/docs/reference/integrations/osquery_manager) integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Schedule collection of information like:* [system_info](https://www.osquery.io/schema/5.1.0/#system_info) for hostname, unique ID, and architecture* [os_version](https://www.osquery.io/schema/5.1.0/#os_version)* [interface_addresses](https://www.osquery.io/schema/5.1.0/#interface_addresses) for IPs and MACs                                                                                                                                                  |
| [System.login](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-dataset-system-login) dataset                                                                     | [Endpoint](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Report login events.                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [Osquery](https://www.elastic.co/docs/reference/integrations/osquery) or [Osquery Manager](https://www.elastic.co/docs/reference/integrations/osquery_manager) integration       | Use the [last](https://www.osquery.io/schema/5.1.0/#last) table for Linux and macOS.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| Fleet [system](https://www.elastic.co/docs/reference/integrations/system) integration                                                                                            | Collect login events for Windows through the [Security event log](https://www.elastic.co/docs/reference/integrations/system#security).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [System.package](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-dataset-system-package) dataset                                                                 | [System Audit](https://www.elastic.co/docs/reference/integrations/system_audit) integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | This integration is a direct replacement for the System Package dataset. Starting in Elastic Stack 8.7, you can port rules and configuration settings to this integration. This integration currently schedules collection of information such as:* [rpm_packages](https://www.osquery.io/schema/5.1.0/#rpm_packages)* [deb_packages](https://www.osquery.io/schema/5.1.0/#deb_packages)* [homebrew_packages](https://www.osquery.io/schema/5.1.0/#homebrew_packages) |
| [Osquery](https://www.elastic.co/docs/reference/integrations/osquery) or [Osquery Manager](https://www.elastic.co/docs/reference/integrations/osquery_manager) integration       | Schedule collection of information like:* [rpm_packages](https://www.osquery.io/schema/5.1.0/#rpm_packages)* [deb_packages](https://www.osquery.io/schema/5.1.0/#deb_packages)* [homebrew_packages](https://www.osquery.io/schema/5.1.0/#homebrew_packages)* [apps](https://www.osquery.io/schema/5.1.0/#apps) (MacOS)* [programs](https://www.osquery.io/schema/5.1.0/#programs) (Windows)* [npm_packages](https://www.osquery.io/schema/5.1.0/#npm_packages)* [atom_packages](https://www.osquery.io/schema/5.1.0/#atom_packages)* [chocolatey_packages](https://www.osquery.io/schema/5.1.0/#chocolatey_packages)* [portage_packages](https://www.osquery.io/schema/5.1.0/#portage_packages)* [python_packages](https://www.osquery.io/schema/5.1.0/#python_packages) |                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [System.process](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-dataset-system-process) dataset                                                                 | [Endpoint](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Best replacement because out of the box it reports events for every process in [ECS](https://www.elastic.co/docs/reference/integrations) format and has excellent integration in Kibana.                                                                                                                                                                                                                                                                              |
| [Custom Windows event log](https://www.elastic.co/docs/reference/integrations/winlog) and [Sysmon](https://www.elastic.co/docs/reference/integrations/sysmon_linux) integrations | Provide process data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [Osquery](https://www.elastic.co/docs/reference/integrations/osquery) or [Osquery Manager](https://www.elastic.co/docs/reference/integrations/osquery_manager) integration       | Collect data from the [process](https://www.osquery.io/schema/5.1.0/#process) table on some operating systems without polling.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [System.socket](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-dataset-system-socket) dataset                                                                   | [Endpoint](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Best replacement because it supports monitoring network connections on Linux, Windows, and MacOS. Includes process and user metadata. Currently does not do flow accounting (byte and packet counts) or domain name enrichment (but does collect DNS queries separately).                                                                                                                                                                                             |
| [Osquery](https://www.elastic.co/docs/reference/integrations/osquery) or [Osquery Manager](https://www.elastic.co/docs/reference/integrations/osquery_manager) integration       | Monitor socket events via the [socket_events](https://www.osquery.io/schema/5.1.0/#socket_events) table for Linux and MacOS.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [System.user](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-dataset-system-user) dataset                                                                       | [Osquery](https://www.elastic.co/docs/reference/integrations/osquery) or [Osquery Manager](https://www.elastic.co/docs/reference/integrations/osquery_manager) integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Monitor local users via the [user](https://www.osquery.io/schema/5.1.0/#user) table for Linux, Windows, and MacOS.                                                                                                                                                                                                                                                                                                                                                    |