﻿---
title: Manage Elastic Agent integrations
description: Elastic Agent integrations provide a simple, unified way to collect data from popular apps and services, and protect systems from security threats. Integrations...
url: https://www.elastic.co/docs/reference/fleet/manage-integrations
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Manage Elastic Agent integrations
Elastic Agent integrations provide a simple, unified way to collect data from popular apps and services, and protect systems from security threats.
Integrations are available for a wide array of popular services and platforms. To see the full list, go to the **Integrations** page in Kibana, or visit [Elastic Integrations](https://www.elastic.co/docs/reference/integrations).
Elastic Agent integrations based on the [Elastic Common Schema](https://www.elastic.co/docs/reference/ecs) (ECS) come prepackaged with assets that support your observability needs:
- Data ingestion, storage, and transformation rules
- Configuration options
- Alert templates to enable users to quickly set up custom alerting rules (available in some integrations) <applies-to>Elastic Stack: Generally available since 9.2</applies-to>
- Pre-built, custom dashboards and visualizations
- Documentation

<applies-to>Elastic Stack: Preview since 9.2</applies-to> Fleet also supports installing Elastic Agent integration packages for collecting and visualizing OpenTelemetry data. For more information, refer to [Collect OpenTelemetry data with Elastic Agent integrations](https://www.elastic.co/docs/reference/fleet/otel-integrations).
The **Integrations** app in Kibana needs access to the public Elastic Package Registry to discover integrations. If your deployment has network restrictions, you can [deploy your own self-managed Elastic Package Registry](/docs/reference/fleet/air-gapped#air-gapped-diy-epr).
<note>
  Some integrations may function differently across different spaces, with some working only in the default space. Review the documentation specific to your integration for any space-related considerations.
</note>


## Work with integrations

You can perform a variety of actions in the **Integrations** app in Kibana. Some of these actions are also available from other places in Kibana.

| User action                                                                                                                                                         | Result                                                                                         |
|---------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------|
| [Add an integration to an Elastic Agent policy](https://www.elastic.co/docs/reference/fleet/add-integration-to-policy)                                              | Configure an integration for a specific use case and add it to an Elastic Agent policy.        |
| [View integration policies](https://www.elastic.co/docs/reference/fleet/view-integration-policies)                                                                  | View the integration policies created for a specific integration.                              |
| [Edit or delete an integration policy](https://www.elastic.co/docs/reference/fleet/edit-delete-integration-policy)                                                  | Change settings or delete the integration policy.                                              |
| [Install and uninstall integration assets](https://www.elastic.co/docs/reference/fleet/install-uninstall-integration-assets)                                        | Install, uninstall, and reinstall integration assets in Kibana.                                |
| [View integration assets](https://www.elastic.co/docs/reference/fleet/view-integration-assets)                                                                      | View the Kibana assets installed for a specific integration.                                   |
| [Upgrade an integration](https://www.elastic.co/docs/reference/fleet/upgrade-integration)                                                                           | Upgrade an integration to the latest version.                                                  |
| [Roll back an integration](https://www.elastic.co/docs/reference/fleet/roll-back-integration) <applies-to>Elastic Stack: Generally available since 9.3</applies-to> | Roll back an integration to the previously installed version if issues occur after an upgrade. |


## Customize integrations

After you've started using integrations to ingest data, you can customize how the data is managed over time. Refer to [Index lifecycle management](/docs/reference/fleet/data-streams#data-streams-ilm) to learn more.