﻿---
title: Centrally manage Elastic Agents in Fleet
description: The Fleet app in Kibana supports both Elastic Agent infrastructure management and agent policy management. You can use Fleet to: Manage Elastic Agent...
url: https://www.elastic.co/docs/reference/fleet/manage-elastic-agents-in-fleet
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Centrally manage Elastic Agents in Fleet
The Fleet app in Kibana supports both Elastic Agent infrastructure management and agent policy management. You can use Fleet to:
- Manage Elastic Agent binaries and specify settings installed on the host that determine whether the agent is enrolled in Fleet, what version of the agent is running, and which agent policy is used.
- Manage agent policies that specify agent configuration settings, which integrations are running, whether agent monitoring is turned on, input settings, and more.

Advanced users who don’t want to use Fleet for central management can use an external infrastructure management solution and [install Elastic Agent in standalone mode](https://www.elastic.co/docs/reference/fleet/install-standalone-elastic-agent) instead.
<important>
  Fleet currently requires a Kibana user with `All` privileges on Fleet and Integrations. Since many Integrations assets are shared across spaces, users need the Kibana privileges in all spaces. Refer to [Required roles and privileges](https://www.elastic.co/docs/reference/fleet/fleet-roles-privileges) to learn how to create a user role with the required privileges to access Fleet and Integrations.
</important>

To learn how to add Elastic Agents to Fleet, refer to [Install Fleet-managed Elastic Agents](https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent).
Find **Fleet** in the Kibana navigation menu, or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). The following table describes the main management actions you can perform in Fleet:

| Component                                                                                                                        | Management actions                                                                                                                       |
|----------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------|
| [Fleet settings](https://www.elastic.co/docs/reference/fleet/fleet-settings)                                                     | Configure global settings available to all Elastic Agents managed by Fleet, including Fleet Server hosts and output settings.            |
| [Elastic Agents](https://www.elastic.co/docs/reference/fleet/manage-agents)                                                      | Enroll, unenroll, upgrade, add tags, and view Elastic Agent status and logs.                                                             |
| [Policies](https://www.elastic.co/docs/reference/fleet/agent-policy)                                                             | Create and edit agent policies and add integrations to them.                                                                             |
| [Fleet enrollment tokens](https://www.elastic.co/docs/reference/fleet/fleet-enrollment-tokens)                                   | Create and revoke enrollment tokens.                                                                                                     |
| [Uninstall tokens](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/prevent-elastic-agent-uninstallation) | (Elastic Defend integration only) Access tokens to allow uninstalling Elastic Agent from endpoints with Agent tamper protection enabled. |
| [Data streams](https://www.elastic.co/docs/reference/fleet/data-streams)                                                         | View data streams and navigate to dashboards to analyze your data.                                                                       |


## Global Fleet management

In Fleet deployments where Elastic Agents are installed in diverse locations and where data must be stored in local clusters, operators need a unified view of all agents and a central management interface for tasks like upgrades, policy organization, and metrics collection. Fleet offers features to facilitate this deployment model:
- [Remote Elasticsearch output](https://www.elastic.co/docs/reference/fleet/remote-elasticsearch-output): Configure Elastic Agents to send data to remote Elasticsearch clusters while still sending their check-in payloads to the management cluster. This allows Fleet on the management cluster to maintain a global view of all agents while the ingested data is routed to the agents' respective local clusters.
- <applies-to>Elastic Stack: Generally available since 9.1</applies-to> [Automatic integrations synchronization](https://www.elastic.co/docs/reference/fleet/automatic-integrations-synchronization): Install an integration once in the management cluster and use Fleet to synchronize and update the integration across all remote clusters. This enables you to initiate services like [OSquery](https://www.elastic.co/docs/reference/integrations/osquery-intro) from the management cluster, and to collect and display responses from dispersed agents in Fleet on the central management cluster.

![A diagram showing Elastic Agents connected to remote data clusters and to a Fleet management cluster](https://www.elastic.co/docs/reference/fleet/images/manage-agents-global-fleet.png)