﻿---
title: Elastic Agents
description: To manage your Elastic Agents, go to Management > Fleet > Agents in Kibana. On the Agents tab, you can perform the following actions: 
url: https://www.elastic.co/docs/reference/fleet/manage-agents
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agents
<tip>
  To learn how to add Elastic Agents to Fleet, see [Install Fleet-managed Elastic Agents](https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent).
</tip>

To manage your Elastic Agents, go to **Management > Fleet > Agents** in Kibana. On the **Agents** tab, you can perform the following actions:

| User action                                                                                                 | Result                                                                                                           |
|-------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------|
| [Unenroll Elastic Agents](https://www.elastic.co/docs/reference/fleet/unenroll-elastic-agent)               | Unenroll Elastic Agents from Fleet.                                                                              |
| [Set inactivity timeout](https://www.elastic.co/docs/reference/fleet/set-inactivity-timeout)                | Set inactivity timeout to move Elastic Agents to inactive status after being offline for the set amount of time. |
| [Upgrade Elastic Agents](https://www.elastic.co/docs/reference/fleet/upgrade-elastic-agent)                 | Upgrade Elastic Agents to the latest version.                                                                    |
| [Migrate Elastic Agents](https://www.elastic.co/docs/reference/fleet/migrate-elastic-agent)                 | Migrate Elastic Agents from one cluster to another.                                                              |
| [Monitor Elastic Agents](https://www.elastic.co/docs/reference/fleet/monitor-elastic-agent)                 | Monitor Fleet-managed Elastic Agents by viewing agent status, logs, and metrics.                                 |
| [Add tags to filter the Agents list](https://www.elastic.co/docs/reference/fleet/filter-agent-list-by-tags) | Add tags to Elastic Agent, then use the tags to filter the Agents list in Fleet.                                 |