﻿---
title: Local dynamic provider
description: Define multiple key-value pairs to generate multiple configurations. For example, the following Elastic Agent policy defines a local dynamic provider...
url: https://www.elastic.co/docs/reference/fleet/local-dynamic-provider
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Local dynamic provider
Define multiple key-value pairs to generate multiple configurations.
For example, the following Elastic Agent policy defines a local dynamic provider that defines three values for `item`:
```yaml
inputs:
 - id: logfile-${local_dynamic.my_var}
   type: logfile
   streams:
     - paths: "/var/${local_dynamic.my_var}/app.log"

providers:
  local_dynamic:
    items:
      - vars:
          my_var: key1
      - vars:
          my_var: key2
      - vars:
          my_var: key3
```

The configuration generated by this policy looks like:
```yaml
inputs:
 - id: logfile-key1
   type: logfile
   streams:
     - paths: "/var/key1/app.log"
 - id: logfile-key2
   type: logfile
   streams:
     - paths: "/var/key2/app.log"
 - id: logfile-key3
   type: logfile
   streams:
   - paths: "/var/key3/app.log"
```