﻿---
title: Set integration-level outputs
description: If your Elastic subscription level supports per integration output assignment, you can configure Elastic Agent data to be sent to different outputs for...
url: https://www.elastic.co/docs/reference/fleet/integration-level-outputs
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Set integration-level outputs
If your [Elastic subscription level](https://www.elastic.co/subscriptions) supports **per integration output assignment**, you can configure Elastic Agent data to be sent to different outputs for different integration policies. The output clusters that you send data to must also be on the same subscription level.
Integration-level outputs are useful for certain scenarios. For example:
- You may want to send security logs monitored by an Elastic Agent to one Logstash output, while informational logs are sent to another Logstash output.
- If you operate multiple Beats on a system and want to migrate these to Elastic Agent, integration-level outputs enable you to maintain the distinct outputs that are currently used by each Beat.


## Order of precedence

For each Elastic Agent, the agent policy configures sending data to the following outputs in decreasing order of priority:
1. The output set in the [integration policy](https://www.elastic.co/docs/reference/fleet/add-integration-to-policy).
2. The output set in the integration’s parent [Elastic Agent policy](https://www.elastic.co/docs/reference/fleet/agent-policy). This includes the case where an integration policy belongs to multiple Elastic Agent policies.
3. The global, default data output set in the [Fleet settings](https://www.elastic.co/docs/reference/fleet/fleet-settings).


## Configure the output for an integration policy

To configure an integration-level output for Elastic Agent data:
1. In Kibana, go to **Integrations**.
2. On the **Installed integrations** tab, select the integration that you’d like to update.
3. Open the **Integration policies** tab.
4. From the **Actions** menu next to the integration, select **Edit integration**.
5. In the **integration settings** section, expand **Advanced options**.
6. Use the **Output** dropdown menu to select an output specific to this integration policy.
7. Click **Save and continue** to confirm your changes.


## View the output configured for an integration

To view which Elastic Agent output is set for an integration policy:
1. In Fleet, open the **Agent policies** tab.
2. Select an Elastic Agent policy.
3. On the **Integrations** tab, the **Output** column indicates the output used for each integration policy. If data is configured to be sent to either the global output defined in Fleet settings or to the integration’s parent Elastic Agent policy, this is indicated in a tooltip.