﻿---
title: Installation layout
description: Elastic Agent files are installed in the following locations. 1  Logs file names end with a date (YYYYMMDD) and optional number: elastic-agent-YYYYMMDD.ndjson,...
url: https://www.elastic.co/docs/reference/fleet/installation-layout
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Installation layout
Elastic Agent files are installed in the following locations.
<tab-set>
  <tab-item title="macOS">
    <definitions>
      <definition term="/Library/Elastic/Agent/*">
        Elastic Agent program files
      </definition>
      <definition term="/Library/Elastic/Agent/elastic-agent.yml">
        Main Elastic Agent configuration
      </definition>
      <definition term="/Library/Elastic/Agent/fleet.enc">
        Main Elastic Agent Fleet encrypted configuration
      </definition>
      <definition term="/Library/Elastic/Agent/data/elastic-agent-*/logs/elastic-agent.ndjson">
        Log files for Elastic Agent and Beats shippers[^1^](#footnote-1)
      </definition>
      <definition term="/usr/bin/elastic-agent">
        Shell wrapper installed into PATH
      </definition>
    </definitions>
    You can install Elastic Agent in a custom base path other than `/Library`.  When installing Elastic Agent with the `./elastic-agent install` command, use the `--base-path` CLI option to specify the custom base path.
  </tab-item>

  <tab-item title="Linux">
    <definitions>
      <definition term="/opt/Elastic/Agent/*">
        Elastic Agent program files
      </definition>
      <definition term="/opt/Elastic/Agent/elastic-agent.yml">
        Main Elastic Agent configuration
      </definition>
      <definition term="/opt/Elastic/Agent/fleet.enc">
        Main Elastic Agent Fleet encrypted configuration
      </definition>
      <definition term="/opt/Elastic/Agent/data/elastic-agent-*/logs/elastic-agent.ndjson">
        Log files for Elastic Agent and Beats shippers[^1^](#footnote-1)
      </definition>
      <definition term="/usr/bin/elastic-agent">
        Shell wrapper installed into PATH
      </definition>
    </definitions>
    You can install Elastic Agent in a custom base path other than `/opt`.  When installing Elastic Agent with the `./elastic-agent install` command, use the `--base-path` CLI option to specify the custom base path.
  </tab-item>

  <tab-item title="Windows">
    <definitions>
      <definition term="C:\Program Files\Elastic\Agent*">
        Elastic Agent program files
      </definition>
      <definition term="C:\Program Files\Elastic\Agent\elastic-agent.yml">
        Main Elastic Agent configuration
      </definition>
      <definition term="C:\Program Files\Elastic\Agent\fleet.enc">
        Main Elastic Agent Fleet encrypted configuration
      </definition>
      <definition term="C:\Program Files\Elastic\Agent\data\elastic-agent-*\logs\elastic-agent.ndjson">
        Log files for Elastic Agent and Beats shippers[^1^](#footnote-1)
      </definition>
    </definitions>
    You can install Elastic Agent in a custom base path other than `C:\Program Files`.  When installing Elastic Agent with the `.\elastic-agent.exe install` command, use the `--base-path` CLI option to specify the custom base path.
  </tab-item>

  <tab-item title="DEB">
    <definitions>
      <definition term="/usr/share/elastic-agent/*">
        Elastic Agent program files
      </definition>
      <definition term="/etc/elastic-agent/elastic-agent.yml">
        Main Elastic Agent configuration
      </definition>
      <definition term="/etc/elastic-agent/fleet.enc">
        Main Elastic Agent Fleet encrypted configuration
      </definition>
      <definition term="/var/lib/elastic-agent/data/elastic-agent-*/logs/elastic-agent.ndjson">
        Log files for Elastic Agent and Beats shippers[^1^](#footnote-1)
      </definition>
      <definition term="/usr/bin/elastic-agent">
        Shell wrapper installed into PATH
      </definition>
    </definitions>
  </tab-item>

  <tab-item title="RPM">
    <definitions>
      <definition term="/usr/share/elastic-agent/*">
        Elastic Agent program files
      </definition>
      <definition term="/etc/elastic-agent/elastic-agent.yml">
        Main Elastic Agent configuration
      </definition>
      <definition term="/etc/elastic-agent/fleet.enc">
        Main Elastic Agent Fleet encrypted configuration
      </definition>
      <definition term="/var/lib/elastic-agent/data/elastic-agent-*/logs/elastic-agent.ndjson">
        Log files for Elastic Agent and Beats shippers[^1^](#footnote-1)
      </definition>
      <definition term="/usr/bin/elastic-agent">
        Shell wrapper installed into PATH
      </definition>
    </definitions>
  </tab-item>
</tab-set>

^1^  Logs file names end with a date `(YYYYMMDD)` and optional number: `elastic-agent-YYYYMMDD.ndjson`, `elastic-agent-YYYYMMDD-1.ndjson`, and so on as new files are created during rotation.