﻿---
title: Install standalone Elastic Agents
description: To run an Elastic Agent in standalone mode, install the agent and manually configure the agent locally on the system where it’s installed. You are responsible...
url: https://www.elastic.co/docs/reference/fleet/install-standalone-elastic-agent
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Install standalone Elastic Agents
To run an Elastic Agent in standalone mode, install the agent and manually configure the agent locally on the system where it’s installed. You are responsible for managing and upgrading the agents. This approach is recommended for advanced users only.
We recommend using [Fleet-managed Elastic Agents](https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent), when possible, because it makes the management and upgrade of your agents considerably easier.
<important>
  Standalone agents are unable to upgrade to new integration package versions automatically. When you upgrade the integration in Kibana, you’ll need to update the standalone policy manually.
</important>

<note>
  You can install only a single Elastic Agent per host.
</note>

Elastic Agent can monitor the host where it’s deployed, and it can collect and forward data from remote services and hardware where direct deployment is not possible.
To install and run Elastic Agent standalone:
1. On your host, download and extract the installation package.
   <tab-set>
   <tab-item title="macOS">
   ```shell
   curl -L -O https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-darwin-aarch64.tar.gz
   tar xzvf elastic-agent-9.3.0-darwin-aarch64.tar.gz
   ```
   </tab-item>

   <tab-item title="Linux">
   ```shell
   curl -L -O https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-linux-x86_64.tar.gz
   tar xzvf elastic-agent-9.3.0-linux-x86_64.tar.gz
   ```
   </tab-item>

   <tab-item title="Windows">
   ```shell
   # PowerShell 5.0+
   wget https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-windows-x86_64.zip -OutFile elastic-agent-9.3.0-windows-x86_64.zip
   Expand-Archive .\elastic-agent-9.3.0-windows-x86_64.zip
   ```
   Or manually:
   1. Download the Elastic Agent Windows zip file from the [download page](https://www.elastic.co/downloads/beats/elastic-agent).
   2. Extract the contents of the zip file.
   </tab-item>

   <tab-item title="DEB">
   <important>
   - To simplify upgrading to future versions of Elastic Agent, we recommended that you use the tarball distribution instead of the DEB distribution.
   - You can install Elastic Agent in an `unprivileged` mode that does not require `root` privileges. Refer to [Run Elastic Agent without administrative privileges](https://www.elastic.co/docs/reference/fleet/elastic-agent-unprivileged) for details.
   </important>

   ```shell
   curl -L -O https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-amd64.deb
   sudo dpkg -i elastic-agent-9.3.0-amd64.deb
   ```
   By default the Elastic Agent basic flavor is installed. To install the servers flavor add the `ELASTIC_AGENT_FLAVOR=servers` parameter. Refer to [Elastic Agent installation flavors](/docs/reference/fleet/install-elastic-agents#elastic-agent-installation-flavors) for details about the different flavors.You can use either of the two command formats to set the `ELASTIC_AGENT_FLAVOR` environment variable:
   ```shell
   curl -L -O https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-amd64.deb
   sudo ELASTIC_AGENT_FLAVOR=servers dpkg -i elastic-agent-9.3.0-amd64.deb
   ```

   ```shell
   curl -L -O https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-amd64.deb
   ELASTIC_AGENT_FLAVOR=servers sudo -E dpkg -i elastic-agent-9.3.0-amd64.deb
   ```

   <note>
   If you need to uninstall an Elastic Agent package on Debian Linux, the `dpkg -r` command to remove a package leaves the flavor file in place. Instead, `dpkg -P` must to be used to purge all package content and reset the flavor.
   </note>
   </tab-item>

   <tab-item title="RPM">
   <important>
   - To simplify upgrading to future versions of Elastic Agent, we recommended that you use the tarball distribution instead of the RPM distribution.
   - You can install Elastic Agent in an `unprivileged` mode that does not require `root` privileges. Refer to [Run Elastic Agent without administrative privileges](https://www.elastic.co/docs/reference/fleet/elastic-agent-unprivileged) for details.
   </important>

   ```shell
   curl -L -O https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-x86_64.rpm
   sudo rpm -vi elastic-agent-9.3.0-x86_64.rpm
   ```
   By default the Elastic Agent basic flavor is installed. To install the servers flavor add the `ELASTIC_AGENT_FLAVOR=servers` parameter. Refer to [Elastic Agent installation flavors](/docs/reference/fleet/install-elastic-agents#elastic-agent-installation-flavors) for details about the different flavors.You can use either of the two command formats to set the `ELASTIC_AGENT_FLAVOR` environment variable:
   ```shell
   curl -L -O https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-x86_64.rpm
   sudo ELASTIC_AGENT_FLAVOR=servers rpm -vi elastic-agent-9.3.0-x86_64.rpm
   ```

   ```shell
   curl -L -O https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-x86_64.rpm
   ELASTIC_AGENT_FLAVOR=servers sudo -E rpm -vi elastic-agent-9.3.0-x86_64.rpm
   ```
   </tab-item>
   </tab-set>
   The commands shown are for either the Intel or ARM platform, but packages for both are available. Refer to the Elastic Agent [downloads page](https://www.elastic.co/downloads/elastic-agent) for the full list of available packages.
2. Modify settings in the `elastic-agent.yml` as required.
   To get started quickly and avoid errors, use Kibana to create and download a standalone configuration file rather than trying to build it by hand. For more information, refer to [Create a standalone Elastic Agent policy](https://www.elastic.co/docs/reference/fleet/create-standalone-agent-policy).
   For additional configuration options, refer to [*Configure standalone Elastic Agents*](https://www.elastic.co/docs/reference/fleet/configure-standalone-elastic-agents).
3. In the `elastic-agent.yml` policy file, under `outputs`, specify an API key or user credentials for the Elastic Agent to access Elasticsearch. For example:
   ```yaml
   [...]
   outputs:
     default:
       type: elasticsearch
       hosts:
         - 'https://da4e3a6298c14a6683e6064ebfve9ace.us-central1.gcp.cloud.es.io:443'
       api_key: _Nj4oH0aWZVGqM7MGop8:349p_U1ERHyIc4Nm8_AYkw 
   [...]
   ```
4. Make sure the assets you need, such as dashboards and ingest pipelines, are set up in Kibana and Elasticsearch. If you used Kibana to generate the standalone configuration, the assets are set up automatically. Otherwise, you need to install them. For more information, refer to [View integration assets](https://www.elastic.co/docs/reference/fleet/view-integration-assets) and [Install integration assets](/docs/reference/fleet/install-uninstall-integration-assets#install-integration-assets).
5. From the agent directory, run the following commands to install Elastic Agent and start it as a service.
   <note>
   On macOS, Linux (tar package), and Windows, run the `install` command to install Elastic Agent as a managed service and start the service. The DEB and RPM packages include a service unit for Linux systems with systemd, so enable then start the service.
   </note>
   <tab-set>
   <tab-item title="macOS">
   <tip>
   You must run this command as the root user because some integrations require root privileges to collect sensitive data.
   </tip>

   ```shell
   sudo ./elastic-agent install
   ```
   By default the Elastic Agent basic flavor is installed. To install the servers flavor, add the `--install-servers` parameter. Refer to [Elastic Agent installation flavors](/docs/reference/fleet/install-elastic-agents#elastic-agent-installation-flavors) for details.
   </tab-item>

   <tab-item title="Linux">
   <tip>
   You must run this command as the root user because some integrations require root privileges to collect sensitive data.
   </tip>

   ```shell
   sudo ./elastic-agent install
   ```
   By default the Elastic Agent basic flavor is installed. To install the servers flavor, add the `--install-servers` parameter. Refer to [Elastic Agent installation flavors](/docs/reference/fleet/install-elastic-agents#elastic-agent-installation-flavors) for details.
   </tab-item>

   <tab-item title="Windows">
   Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select **Run As Administrator**).From the PowerShell prompt, change to the directory where you installed Elastic Agent, and run:
   ```shell
   .\elastic-agent.exe install
   ```
   By default the Elastic Agent basic flavor is installed. To install the servers flavor, add the `--install-servers` parameter. Refer to [Elastic Agent installation flavors](/docs/reference/fleet/install-elastic-agents#elastic-agent-installation-flavors) for details.
   </tab-item>

   <tab-item title="DEB">
   ```shell
   sudo systemctl enable elastic-agent 
   sudo systemctl start elastic-agent
   ```
   </tab-item>

   <tab-item title="RPM">
   ```shell
   sudo systemctl enable elastic-agent 
   sudo systemctl start elastic-agent
   ```
   </tab-item>
   </tab-set>

Refer to [Installation layout](https://www.elastic.co/docs/reference/fleet/installation-layout) for the location of installed Elastic Agent files.
Because Elastic Agent is installed as an auto-starting service, it will restart automatically if the system is rebooted.
If you run into problems, refer to [Common problems with Fleet and Elastic Agent](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems).