﻿---
title: Install Elastic Agent on Kubernetes using Helm
description: Starting with Elastic Stack version 8.16, a Helm chart is available for installing Elastic Agent in a Kubernetes environment. A Helm-based install offers...
url: https://www.elastic.co/docs/reference/fleet/install-on-kubernetes-using-helm
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Install Elastic Agent on Kubernetes using Helm
Starting with Elastic Stack version 8.16, a Helm chart is available for installing Elastic Agent in a Kubernetes environment. A Helm-based install offers several advantages, including simplified deployment, availability in marketplaces, streamlined upgrades, as well as quick rollbacks whenever they’re needed.
Features of the Helm-based Elastic Agent install include:
- Support for both standalone and Fleet-managed Elastic Agent.
- For standalone agents, a built-in Kubernetes policy similar to that available in Fleet for Fleet-managed agents.
- Support for custom integrations.
- Support for Elasticsearch outputs with authentication through username and password, an API key, or a stored secret.
- Easy switching between privileged (`root`) and unprivileged Elastic Agent deployments.
- Support for Elastic Stack deployments on Elastic Cloud on Kubernetes.

For detailed install steps, try one of our walk-through examples:
- [Example: Install standalone Elastic Agent on Kubernetes using Helm](https://www.elastic.co/docs/reference/fleet/example-kubernetes-standalone-agent-helm)
- [Example: Install Fleet-managed Elastic Agent on Kubernetes using Helm](https://www.elastic.co/docs/reference/fleet/example-kubernetes-fleet-managed-agent-helm)

<note>
  The Elastic Agent Helm chart is currently available from inside the [elastic/elastic-agent](https://github.com/elastic/elastic-agent) GitHub repo. It’s planned to soon make the chart available from the Elastic Helm repository.
</note>

You can also find details about the Helm chart, including all available YAML settings and descriptions, in the [Elastic Agent Helm Chart Readme](https://github.com/elastic/elastic-agent/tree/main/deploy/helm/elastic-agent). Several [examples](https://github.com/elastic/elastic-agent/tree/main/deploy/helm/elastic-agent/examples) are available if you’d like to explore other use cases.