﻿---
title: Install Fleet-managed Elastic Agents
description: To get up and running quickly, read one of our end-to-end guides: New to Elastic? Read our solution Getting started guides.Want to add data to an existing...
url: https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Install Fleet-managed Elastic Agents
<admonition title="Admonition">
  Fleet is a web-based UI in Kibana for [centrally managing Elastic Agents](https://www.elastic.co/docs/reference/fleet/manage-elastic-agents-in-fleet). To use Fleet, you install Elastic Agent, then enroll the agent in a policy defined in Kibana. The policy includes integrations that specify how to collect observability data from specific services and protect endpoints. The Elastic Agent connects to a trusted [Fleet Server](https://www.elastic.co/docs/reference/fleet/fleet-server) instance to retrieve the policy and report agent events.
</admonition>


## Where to start

To get up and running quickly, read one of our end-to-end guides:
- New to Elastic? Read our solution [Getting started guides](https://www.elastic.co/docs/get-started).
- Want to add data to an existing cluster or deployment? Read our [*Quick starts*](https://www.elastic.co/docs/reference/fleet).

Looking for upgrade info? Refer to [Upgrade Elastic Agents](https://www.elastic.co/docs/reference/fleet/upgrade-elastic-agent).
Want to learn how to install Elastic Agent? Continue reading this page.

## Prerequisites

You will always need:
- **A Kibana user with `All` privileges on Fleet and Integrations.** Since many Integrations assets are shared across spaces, users need the Kibana privileges in all spaces.
- **[Fleet Server](https://www.elastic.co/docs/reference/fleet/fleet-server) running in a location accessible to Elastic Agent.** Elastic Agent must have a direct network connection to Fleet Server and Elasticsearch. If you’re using Elastic Cloud, Fleet Server is already available as part of the Integrations Server. For self-managed deployments, refer to [Deploy on-premises and self-managed](https://www.elastic.co/docs/reference/fleet/add-fleet-server-on-prem).
- **Internet connection for Kibana to download integration packages from the Elastic Package Registry.** Make sure the Kibana server can connect to `https://epr.elastic.co` on port `443`. If your environment has network traffic restrictions, there are ways to work around this requirement. See [Air-gapped environments](https://www.elastic.co/docs/reference/fleet/air-gapped) for more information.

If you are using a Fleet Server that uses your organization’s certificate, you will also need:
- **A Certificate Authority (CA) certificate to configure Transport Layer Security (TLS) to encrypt traffic.** If your organization already uses the Elastic Stack, you may already have a CA certificate. If you do not have a CA certificate, you can read more about generating one in [Configure SSL/TLS for self-managed Fleet Servers](https://www.elastic.co/docs/reference/fleet/secure-connections).

If you’re running Elastic Agent 7.9 or earlier, stop the agent and manually remove it from your host.

## Installation steps

<note>
  You can install only a single Elastic Agent per host.
</note>

Elastic Agent can monitor the host where it’s deployed, and it can collect and forward data from remote services and hardware where direct deployment is not possible.
To install an Elastic Agent and enroll it in Fleet:
1. In Fleet, open the **Agents** tab and click **Add agent**.
2. In the **Add agent** flyout, select an existing agent policy or create a new one. If you create a new policy, Fleet generates a new [Fleet enrollment token](https://www.elastic.co/docs/reference/fleet/fleet-enrollment-tokens).
   <note>
   For on-premises deployments, you can dedicate a policy to all the agents in the network boundary and configure that policy to include a specific Fleet Server (or a cluster of Fleet Servers).Read more in [Add a Fleet Server to a policy](/docs/reference/fleet/agent-policy#add-fleet-server-to-policy).
   </note>
3. Make sure **Enroll in Fleet** is selected.
4. Download, install, and enroll the Elastic Agent on your host by selecting your host operating system and following the **Install Elastic Agent on your host** step. The commands shown are for AMD platforms, but ARM packages are also available. Refer to the Elastic Agent [downloads page](https://www.elastic.co/downloads/elastic-agent) for the full list of available packages.
   1. If you are enrolling the agent in a Fleet Server that uses your organization’s certificate you *must* add the `--certificate-authorities` option to the command provided in the in-product instructions. If you do not include the certificate, you will see the following error: "x509: certificate signed by unknown authority".
2. Beginning with version 9.0, Elastic Agent packages are available in multiple flavors. The default, "basic" flavor contains the components required for most use data collection use cases. A "servers" flavor is also available with additional components. You can adjust the `elastic-agent install` command as required to choose a different flavor. Refer to [Elastic Agent installation flavors](/docs/reference/fleet/install-elastic-agents#elastic-agent-installation-flavors) for details.
   ![Add agent flyout in Kibana](https://www.elastic.co/docs/reference/fleet/images/kibana-agent-flyout.png)

After about a minute, the agent will enroll in Fleet, download the configuration specified in the agent policy, and start collecting data.
**Notes:**
- If you encounter an "x509: certificate signed by unknown authority" error, you might be trying to enroll in a Fleet Server that uses self-signed certs. To fix this problem in a non-production environment, pass the `--insecure` flag. For more information, refer to the [troubleshooting guide](/docs/troubleshoot/ingest/fleet/common-problems#agent-enrollment-certs).
- Optionally, you can use the `--tag` flag to specify a comma-separated list of tags to apply to the enrolled Elastic Agent. For more information, refer to [Filter list of Agents by tags](https://www.elastic.co/docs/reference/fleet/filter-agent-list-by-tags).
- Refer to [Installation layout](https://www.elastic.co/docs/reference/fleet/installation-layout) for the location of installed Elastic Agent files.
- Because Elastic Agent is installed as an auto-starting service, it will restart automatically if the system is rebooted.

To confirm that Elastic Agent is installed and running, open the **Agents** tab in Fleet.
![Fleet showing enrolled agents](https://www.elastic.co/docs/reference/fleet/images/kibana-fleet-agents.png)

<tip>
  If the status hangs at Enrolling, make sure the `elastic-agent` process is running.
</tip>

If you run into problems:
- Check the Elastic Agent logs. If you use the default policy, agent logs and metrics are collected automatically unless you change the default settings. For more information, refer to [Monitor Elastic Agent in Fleet](https://www.elastic.co/docs/reference/fleet/monitor-elastic-agent).
- Refer to [Common problems with Fleet and Elastic Agent](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems).

For information about managing Elastic Agent in Fleet, refer to [Centrally manage Elastic Agents in Fleet](https://www.elastic.co/docs/reference/fleet/manage-elastic-agents-in-fleet).