﻿---
title: Install Elastic Agents
description: Note the following restrictions when installing Elastic Agent on your system: You can install only a single Elastic Agent per host. Due to the fact that...
url: https://www.elastic.co/docs/reference/fleet/install-elastic-agents
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Install Elastic Agents
Note the following restrictions when installing Elastic Agent on your system:
- You can install only a single Elastic Agent per host. Due to the fact that the Elastic Agent may read data sources that are only accessible by a superuser, Elastic Agent will therefore also need to be executed with superuser permissions.
- You might need to log in as a root user (or Administrator on Windows) to run the commands described here. After the Elastic Agent service is installed and running, make sure you run these commands without prepending them with `./` to avoid invoking the wrong binary.
- Running Elastic Agent commands using the Windows PowerShell ISE is not supported.
- See also the [resource requirements](#elastic-agent-installation-resource-requirements) described on this page.

<note>
  Elastic Agent requires a writable file system to operate. It needs to write configuration files, logs, and other runtime data during installation and normal operation. If you're running Elastic Agent in a containerized environment with a read-only root file system, you must provide a writable location for the agent to use. For more information, refer to [Run Elastic Agent in a container](https://www.elastic.co/docs/reference/fleet/elastic-agent-container).
</note>

<admonition title="New FIPS compatible install packages" applies-to="Elastic Stack: Preview since 9.1">
  FIPS compatible binaries for Elastic Agent, Fleet, and other ingest tools are available for download. Look for the `Linux 64-bit (FIPS)` or `Linux aarch64 (FIPS)` platform option on the product [download page](https://www.elastic.co/downloads). Get more details about FIPS compatibility for Elastic Agent, Fleet and other ingest tools in [FIPS mode for Ingest tools](https://www.elastic.co/docs/deploy-manage/security/fips-ingest).
</admonition>

You have a few options for installing and managing an Elastic Agent:
- **Install a Fleet-managed Elastic Agent (recommended)**
  With this approach, you install Elastic Agent and use Fleet in Kibana to define, configure, and manage your agents in a central location.
  We recommend using Fleet management because it makes the management and upgrade of your agents considerably easier.
  Refer to [Install Fleet-managed Elastic Agents](https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent).
- **Install Elastic Agent in standalone mode (advanced users)**
  With this approach, you install Elastic Agent and manually configure the agent locally on the system where it’s installed. You are responsible for managing and upgrading the agents. This approach is reserved for advanced users only.
  Refer to [Install standalone Elastic Agents](https://www.elastic.co/docs/reference/fleet/install-standalone-elastic-agent).
- **Install Elastic Agent in a containerized environment**
  You can run Elastic Agent inside of a container — either with Fleet Server or standalone. Docker images for all versions of Elastic Agent are available from the Elastic Docker registry, and we provide deployment manifests for running on Kubernetes.
  Refer to:
  - [Run Elastic Agent in a container](https://www.elastic.co/docs/reference/fleet/elastic-agent-container)
- [Run Elastic Agent on Kubernetes managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-kubernetes-managed-by-fleet)
  - [Advanced Elastic Agent configuration managed by Fleet](https://www.elastic.co/docs/reference/fleet/advanced-kubernetes-managed-by-fleet)
- [Configuring Kubernetes metadata enrichment on Elastic Agent](https://www.elastic.co/docs/reference/fleet/configuring-kubernetes-metadata)
- [Run Elastic Agent on GKE managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-gke-managed-by-fleet)
- [Run Elastic Agent on Amazon EKS managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-eks-managed-by-fleet)
- [Run Elastic Agent on Azure AKS managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-aks-managed-by-fleet)
- [Run Elastic Agent Standalone on Kubernetes](https://www.elastic.co/docs/reference/fleet/running-on-kubernetes-standalone)
- [Scaling Elastic Agent on Kubernetes](https://www.elastic.co/docs/reference/fleet/scaling-on-kubernetes)
- [Run Elastic Agent on ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/standalone-elastic-agent) — for Elastic Cloud on Kubernetes users

<admonition title="Restrictions in Serverless">
  If you are using Elastic Agent with [Elastic Cloud Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless), note these differences from use with Elastic Cloud Hosted and self-managed Elasticsearch:
  - The number of Elastic Agents that may be connected to an Elastic Cloud Serverless project is limited to 10 thousand.
  - The minimum supported version of Elastic Agent supported for use with Elastic Cloud Serverless is 8.11.0.
</admonition>

<admonition title="Applying Elastic Agent configurations dynamically">
  When you set up Elastic Agent, you might not yet have all input configuration details available. To solve this problem, the input configuration accepts variables and conditions that get evaluated at runtime using information from the running environment, allowing you to apply configurations dynamically. To learn more, refer to [Variables and conditions in input configurations](https://www.elastic.co/docs/reference/fleet/dynamic-input-configuration).
</admonition>


## Elastic Agent installation flavors

Elastic Agent distribution packages are offered in multiple flavors. This gives you control over the set of components included in the package and the size of the package footprint when it's installed.

### Flavors for regular package installs


#### Basic flavor

The basic Elastic Agent flavor is installed by default using the `elastic-agent install` command with an agent package: `.zip`, .`tar.gz`, `.deb`, `.rpm`, or `.msi`. This flavor includes only the following components:
- `agentbeat` - used to implement all [Beats](https://www.elastic.co/docs/reference/beats)-based integrations.
- `endpoint-security` - used to implement [Elastic Defend](https://www.elastic.co/docs/solutions/security/configure-elastic-defend).
- `pf-host-agent` - used to collect profiling data from hosts as part of Elastic [Universal Profiling](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/get-started-with-universal-profiling).

This basic package is suitable for most use cases and it offers a reduced size on disk.

#### Servers flavor

The servers Elastic Agent flavor is installed using the `elastic-agent install --install-servers` command, or for RPM and DEB packages the `ELASTIC_AGENT_FLAVOR=servers` environment variable. In addition to components included in the basic flavor, this flavor also includes:
- `apm-server` - implements the Elastic [APM Server](https://www.elastic.co/docs/solutions/observability/apm/get-started).
- `cloudbeat` - implements [Cloud Security Posture Management (CSPM)](https://www.elastic.co/docs/solutions/security/cloud/cloud-security-posture-management) integrations.
- `fleet-server`, implements [Fleet Server](https://www.elastic.co/docs/reference/fleet/fleet-server) for managing Elastic Agents.
- `pf-elastic-symbolizer` - a server side component of Elastic [Universal Profiling](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/get-started-with-universal-profiling).
- `pf-elastic-collector` - a server side component of Elastic [Universal Profiling](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/get-started-with-universal-profiling).

Beginning in version 9.0, for Elastic Agents to have the full functionality that was supported by default in pre-9.x versions, you need to install the servers Elastic Agent flavor.

### Flavors for container package installs


#### Basic flavor

For containerized environments, the basic Elastic Agent flavor is installed using the `elastic-agent-slim` command with an agent container package. This flavor contains the same set of components described in [Basic flavor](#elastic-agent-basic-flavor-regular) above.

#### Servers flavor

For containerized environments, the servers Elastic Agent flavor is installed using the default `elastic-agent` command with an agent container package. This flavor contains the same set of components described in [Servers flavor](#elastic-agent-servers-flavor-regular) above.
<applies-to>Elastic Stack: Generally available since 9.1</applies-to> The servers Elastic Agent flavor also includes the [journald](https://www.freedesktop.org/software/systemd/man/latest/systemd-journald.service.html) dependencies necessary to use the [journald input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-journald).

#### Complete flavor

For containerized environments, the complete Elastic Agent flavor is installed using the `elastic-agent-complete` command with an agent container package. This flavor includes all of the components in the servers flavor, and also includes additional dependencies to run browser monitors through Elastic Synthetics. Refer to [Synthetic monitoring via Elastic Agent and Fleet](https://www.elastic.co/docs/solutions/observability/synthetics/get-started) for more information.
The complete Elastic Agent flavor also includes the [journald](https://www.freedesktop.org/software/systemd/man/latest/systemd-journald.service.html) dependencies necessary to use the [journald input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-journald).

## Resource requirements

The Elastic Agent resources consumption is influenced by the number of integration and the environment its been running on.
Using our lab environment as an example, we can observe the following resource consumption:

### CPU and RSS memory size

We tested using an AWS `m7i.large` instance type with 2 vCPUs, 8.0 GB of memory, and up to 12.5 Gbps of bandwidth. The tests ingested a single log file using both the [throughput and scale preset](/docs/reference/fleet/elasticsearch-output#output-elasticsearch-performance-tuning-settings) with self monitoring enabled. These tests are representative of use cases that attempt to ingest data as fast as possible. This does not represent the resource overhead when using [Elastic Defend](https://www.elastic.co/docs/reference/integrations/endpoint).

| Resource                              | Throughput | Scale    |
|---------------------------------------|------------|----------|
| **CPU**[^1^](#footnote-1)             | ~67%       | ~20%     |
| **RSS memory size**[^1^](#footnote-1) | ~280 MB    | ~220 MB  |
| **Write network throughput**          | ~3.5 MB/s  | 480 KB/s |

^1^  including all monitoring processes
Adding integrations will increase the memory used by the agent and its processes.

### Size on disk

The disk requirements for Elastic Agent vary by operating system and Elastic Stack version.

| Operating system | 8.13    | 8.14    | 8.15    | 8.18   | 9.0    |
|------------------|---------|---------|---------|--------|--------|
| **Linux**        | 1800 MB | 1018 MB | 1060 MB | 1.5 GB | 1.5 GB |
| **macOS**        | 1100 MB | 619 MB  | 680 MB  | 775 MB | 775 MB |
| **Windows**      | 891 MB  | 504 MB  | 500 MB  | 678 MB | 705 MB |

During upgrades, double the disk space is required to store the new Elastic Agent binary. After the upgrade completes, the original Elastic Agent is removed from disk to free up the space.