﻿---
title: Install Elastic Agents in a containerized environment
description: You can run Elastic Agent inside of a container — either with Fleet Server or standalone. Docker images for all versions of Elastic Agent are available...
url: https://www.elastic.co/docs/reference/fleet/install-elastic-agents-in-containers
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Install Elastic Agents in a containerized environment
You can run Elastic Agent inside of a container — either with Fleet Server or standalone. Docker images for all versions of Elastic Agent are available from the Elastic Docker registry, and we provide deployment manifests for running on Kubernetes.
To learn how to run Elastic Agents in a containerized environment, see:
- [Run Elastic Agent in a container](https://www.elastic.co/docs/reference/fleet/elastic-agent-container)
- [Run Elastic Agent on Kubernetes managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-kubernetes-managed-by-fleet)
  - [Advanced Elastic Agent configuration managed by Fleet](https://www.elastic.co/docs/reference/fleet/advanced-kubernetes-managed-by-fleet)
- [Configuring Kubernetes metadata enrichment on Elastic Agent](https://www.elastic.co/docs/reference/fleet/configuring-kubernetes-metadata)
- [Run Elastic Agent on GKE managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-gke-managed-by-fleet)
- [Run Elastic Agent on Amazon EKS managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-eks-managed-by-fleet)
- [Run Elastic Agent on Azure AKS managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-aks-managed-by-fleet)
- [Run Elastic Agent Standalone on Kubernetes](https://www.elastic.co/docs/reference/fleet/running-on-kubernetes-standalone)
- [Scaling Elastic Agent on Kubernetes](https://www.elastic.co/docs/reference/fleet/scaling-on-kubernetes)
- [Using a custom ingest pipeline with the Kubernetes Integration](https://www.elastic.co/docs/reference/fleet/ingest-pipeline-kubernetes)
- [Run Elastic Agent on ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/standalone-elastic-agent) — for Elastic Cloud on Kubernetes users

<note>
  Enrollment handling for Elastic Agent in a containerized environment has some special nuances.
  For details refer to [Enrollment handing for containerized agents](https://www.elastic.co/docs/reference/fleet/enrollment-handling-containerized-agent).
</note>