﻿---
title: Install Elastic Agent from an MSI package
description: MSI is the file format and command line utility for the Windows Installer. Windows Installer (previously known as Microsoft Installer) is an interface...
url: https://www.elastic.co/docs/reference/fleet/install-agent-msi
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Install Elastic Agent from an MSI package
MSI is the file format and command line utility for the [Windows Installer](https://en.wikipedia.org/wiki/Windows_Installer). Windows Installer (previously known as Microsoft Installer) is an interface for Microsoft Windows that’s used to install and manage software on Windows systems. This section covers installing Elastic Agent through the MSI package repository.
The MSI package installer must be run by an administrator account. The installer won’t start without Windows admin permissions.

## Install Elastic Agent

1. Download the latest Elastic Agent MSI binary from the [Elastic Agent download page](https://www.elastic.co/downloads/elastic-agent).
2. Run the installer. The command varies slightly depending on whether you’re using the default Windows command prompt or PowerShell.
   <admonition title="Admonition">
   - Using the default command prompt:
   ```shell
   elastic-agent-<VERSION>-windows-x86_64.msi INSTALLARGS="--url=<URL> --enrollment-token=<TOKEN>"
   ```
   - Using PowerShell:
   ```shell
   ./elastic-agent-<VERSION>-windows-x86_64.msi --% INSTALLARGS="--url=<URL> --enrollment-token=<TOKEN>"
   ```
   </admonition>
   Where:
   - `VERSION` is the Elastic Stack version you’re installing, indicated in the MSI package name. For example, `8.13.2`.
- `URL` is the Fleet Server URL used to enroll the Elastic Agent into Fleet. You can find this on the Fleet **Settings** tab in Kibana.
- `TOKEN` is the authentication token used to enroll the Elastic Agent into Fleet. You can find this on the Fleet **Enrollment tokens** tab.
   When you run the command, the value set for `INSTALLARGS` will be passed to the [`elastic-agent install`](/docs/reference/fleet/agent-command-reference#elastic-agent-install-command) command verbatim.
3. If you need to troubleshoot, you can install using `msiexec` with the `-L*V "log.txt"` option to create installation logs:
   ```shell
   msiexec -i elastic-agent-<VERSION>-windows-x86_64.msi INSTALLARGS="--url=<URL> --enrollment-token=<TOKEN>"  -L*V "log.txt"
   ```


## Installation notes

Installing using an MSI package has the following behaviors:
- If `INSTALLARGS` are not provided, the MSI will copy the files to a temporary folder and finish.
- If `INSTALLARGS` are provided, the MSI will copy the files to a temporary folder and then run the [`elastic-agent install`](/docs/reference/fleet/agent-command-reference#elastic-agent-install-command) command with the provided parameters. If the install flow is successful, the temporary folder is deleted.
- If `INSTALLARGS` are provided but the `elastic-agent install` command fails, the top-level folder is NOT deleted, in order to allow for further troubleshooting.
- If the `elastic-agent install` command fails for any reason, the MSI will rollback all changes.
- If the Elastic Agent enrollment fails, the install will fail as well. To avoid this behavior you can add the [`--delay-enroll`](/docs/reference/fleet/agent-command-reference#elastic-agent-install-command) option to the install command.


## Upgrading

The Elastic Agent version can be upgraded through Fleet, but the registered MSI version at Windows Registry will display the initially installed version (this shortcoming will be addressed in future releases) while Fleet and ingested data metadata will show the correct installed version for the Elastic Agent. Attempts to upgrade outside of Fleet through the MSI will require an uninstall and reinstall procedure to upgrade. This MSI implementation relies on the tar Elastic Agent binary to upgrade the installation. Therefore if the Elastic Agent is installed in an air-gapped environment, you must ensure that the tar image is available before an upgrade request is issued.

## Installing in a custom location

Starting in version 8.13, it’s also possible to override the default installation folder by running the MSI from the command line, as shown:
```shell
elastic-agent-<VERSION>-windows-x86_64.msi INSTALLARGS="--url=<URL> --enrollment-token=<TOKEN>" INSTALLDIR="<path of custom folder>"
```