﻿---
title: Keep fields from events
description: The include_fields processor specifies which fields to export if a certain condition is fulfilled. The condition is optional. If it’s missing, the specified...
url: https://www.elastic.co/docs/reference/fleet/include_fields-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Keep fields from events
The `include_fields` processor specifies which fields to export if a certain condition is fulfilled. The condition is optional. If it’s missing, the specified fields are always exported. The `@timestamp`, `@metadata`, and `type` fields are always exported, even if they are not defined in the `include_fields` list.

## Example

```yaml
  - include_fields:
      when:
        condition
      fields: ["field1", "field2", ...]
```

See [Conditions](/docs/reference/fleet/dynamic-input-configuration#conditions) for a list of supported conditions.
<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that your processor configurations cannot refer to fields that are created by ingest pipelines or Logstash. For more limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>

You can specify multiple `include_fields` processors under the `processors` section.
<note>
  If you define an empty list of fields under `include_fields`, only the required fields, `@timestamp` and `type`, are exported.
</note>