﻿---
title: Grant standalone Elastic Agents access to Elasticsearch
description: You can use either API keys (recommended) or user credentials to grant standalone Elastic Agents access to Elasticsearch resources. The following minimal...
url: https://www.elastic.co/docs/reference/fleet/grant-access-to-elasticsearch
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Grant standalone Elastic Agents access to Elasticsearch
You can use either API keys (recommended) or user credentials to grant standalone Elastic Agents access to Elasticsearch resources.
<important>
  API key authentication is required for Elastic Cloud Serverless. API key authentication is recommended for Elastic Stack deployments in order to avoid exposing usernames and passwords in configuration files.
</important>

The following minimal permissions are required to send logs, metrics, traces, and synthetics to Elasticsearch:
- `monitor` cluster privilege
- `auto_configure` and `create_doc` index privileges on `logs-*-*`, `metrics-*-*`, `traces-*-*`, and `synthetics-*-*`.


## Create API keys for standalone agents

<note>
  API keys are sent as plain-text, so they only provide security when used in combination with Transport Layer Security (TLS). [Elastic Cloud](https://www.elastic.co/cloud/elasticsearch-service?page=docs&placement=docs-body) provides secure, encrypted connections out of the box! For self-managed Elasticsearch clusters, refer to [Public Key Infrastructure (PKI) certificates](/docs/reference/fleet/elasticsearch-output#output-elasticsearch-pki-certs-authentication-settings).
</note>

You can set API keys to expire at a certain time, and you can explicitly invalidate them. Any user with the `manage_api_key` or `manage_own_api_key` cluster privilege can create API keys.
For security reasons, we recommend using a unique API key per Elastic Agent. You can create as many API keys per user as necessary.
If you are using [Elastic Cloud Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless), API key authentication is required.
To create an API key for Elastic Agent:
1. In an Elastic Cloud or on premises environment, in Kibana navigate to **Stack Management > API keys** and click **Create API key**.
   In a Serverless environment, in Kibana navigate to **Project settings** > **Management** > **API keys** and click **Create API key**.
2. Enter a name for your API key and select **Control security privileges**.
3. In the role descriptors box, copy and paste the following JSON. This example creates an API key with privileges for ingesting logs, metrics, traces, and synthetics:
   ```json
   {
     "standalone_agent": {
       "cluster": [
         "monitor"
       ],
       "indices": [
         {
           "names": [
             "logs-*-*", "metrics-*-*", "traces-*-*", "synthetics-*-*" 
           ],
           "privileges": [
             "auto_configure", "create_doc"
           ]
         }
       ]
     }
   }
   ```
4. To set an expiration date for the API key, select **Expire after time** and input the lifetime of the API key in days.
5. Click **Create API key**.
   You’ll see a message indicating that the key was created, along with the encoded key. By default, the API key is Base64 encoded, but that won’t work for Elastic Agent.
6. Click the down arrow next to Base64 and select **Beats**.
   ![Message with field for copying API key](https://www.elastic.co/docs/reference/fleet/images/copy-api-key.png)
7. Copy the API key. You will need this for the next step, and you will not be able to view it again.
8. To use the API key, specify the `api_key` setting in the `elastic-agent.yml` file. For example:
   ```yaml
   [...]
   outputs:
     default:
       type: elasticsearch
       hosts:
         - 'https://da4e3a6298c14a6683e6064ebfve9ace.us-central1.gcp.cloud.es.io:443'
       api_key: _Nj4oH0aWZVGqM7MGop8:349p_U1ERHyIc4Nm8_AYkw 
   [...]
   ```

For more information about creating API keys in Kibana, see [API Keys](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys).

## Create a standalone agent role

Although it’s recommended that you use an API key instead of a username and password to access Elasticsearch (and an API key is required in a Serverless environment), you can create a role with the required privileges, assign it to a user, and specify the user’s credentials in the `elastic-agent.yml` file.
1. In Kibana, go to **Stack Management > Roles**.
2. Click **Create role** and enter a name for the role.
3. In **Cluster privileges**, enter `monitor`.
4. In **Index privileges**, enter:
   1. `logs-*-*`, `metrics-*-*`, `traces-*-*` and `synthetics-*-*` in the **Indices** field.
   <note>
   Adjust this list to match the data you want to collect. For example, if you aren’t using APM or synthetics, remove `traces-*-*` and `synthetics-*-*` from this list.
   </note>
2. `auto_configure` and `create_doc` in the **Privileges** field.
   ![Create role settings for a standalone agent role](https://www.elastic.co/docs/reference/fleet/images/create-standalone-agent-role.png)
5. Create the role and assign it to a user. For more information about creating roles, refer to [Kibana role management](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles).
6. To use these credentials, set the username and password in the `elastic-agent.yml` file:
   ```yaml
   [...]
   outputs:
     default:
       type: elasticsearch
       hosts:
         - 'https://da4e3a6298c14a6683e6064ebfve9ace.us-central1.gcp.cloud.es.io:443'
       username: ES_USERNAME 
       password: ES_PASSWORD
   [...]
   ```