﻿---
title: Fleet settings
description: On the Settings tab in Fleet, you can configure global settings available to all Elastic Agents enrolled in Fleet. This includes Fleet Server hosts and...
url: https://www.elastic.co/docs/reference/fleet/fleet-settings
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Fleet settings
<note>
  The settings described here are configurable through the Fleet UI. Refer to [Fleet settings in Kibana](https://www.elastic.co/docs/reference/kibana/configuration-reference/fleet-settings) for a list of settings that you can configure in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) configuration file.
</note>

On the **Settings** tab in **Fleet**, you can configure global settings available to all Elastic Agents enrolled in Fleet. This includes Fleet Server hosts and output settings.

## Fleet Server host settings

Select **Edit hosts** and specify the host URLs your Elastic Agents will use to connect to a Fleet Server.
<tip>
  If the **Edit hosts** option is grayed out, Fleet Server hosts are configured outside of Fleet. For more information, refer to [Fleet settings in Kibana](https://www.elastic.co/docs/reference/kibana/configuration-reference/fleet-settings).
</tip>

Not sure if Fleet Server is running? Refer to [What is Fleet Server?](https://www.elastic.co/docs/reference/fleet/fleet-server).
On self-managed clusters, you must specify one or more URLs.
On Elastic Cloud, this field is populated automatically. If you are using Azure Private Link, GCP Private Service Connect, or AWS PrivateLink and enrolling the Elastic Agent with a private link URL, ensure that this setting is configured. Otherwise, Elastic Agent will reset to use a default address instead of the private link URL.
<note>
  If a URL is specified without a port, Kibana sets the port to `80` (http) or `443` (https).
</note>

By default, Fleet Server is typically exposed on the following ports:
<definitions>
  <definition term="8220">
    Default Fleet Server port for self-managed clusters
  </definition>
  <definition term="443 or 9243">
    Default Fleet Server port for Elastic Cloud. View the Fleet **Settings** tab to find the actual port that’s used.
  </definition>
</definitions>

<important>
  The exposed ports must be open for ingress and egress in the firewall and networking rules on the host to allow Elastic Agents to communicate with Fleet Server.
</important>

Specify multiple URLs (select **Add row**) to scale out your deployment and provide automatic failover. If multiple URLs exist, Fleet shows the first provided URL for enrollment purposes. Enrolled Elastic Agents will connect to the URLs in round robin order until they connect successfully.
When a Fleet Server is added or removed from the list, all agent policies are updated automatically.
**Examples:**
- `https://192.0.2.1:8220`
- `https://abae718c1276457893b1096929e0f557.fleet.eu-west-1.aws.qa.cld.elstc.co:443`
- `https://[2001:db8::1]:8220`


## Output settings

Add or edit output settings to specify where Elastic Agents send data. Elastic Agents use the default output if you don’t select an output in the agent policy.
<tip>
  If your [Elastic subscription level](https://www.elastic.co/subscriptions) supports **per integration output assignment**, you can configure Elastic Agent to [send data to different outputs for different integration policies](https://www.elastic.co/docs/reference/fleet/integration-level-outputs).
</tip>

<note>
  The Elastic Cloud internal output is locked and cannot be edited. This output is used for internal routing to reduce external network charges when using the Elastic Cloud agent policy. It also provides visibility for troubleshooting on Elastic Cloud Enterprise.
</note>

To add or edit an output:
1. Go to **Fleet** > **Settings**.
2. Under **Outputs**, select **Add output** or **Edit**.
   ![Fleet Add output button](https://www.elastic.co/docs/reference/fleet/images/fleet-add-output-button.png)
   The **Add new output** UI opens.
3. Set the output name and type.
4. Specify settings for the output type you selected:
   - [Elasticsearch output settings](https://www.elastic.co/docs/reference/fleet/es-output-settings)
- [Logstash output settings](https://www.elastic.co/docs/reference/fleet/ls-output-settings)
- [Kafka output settings](https://www.elastic.co/docs/reference/fleet/kafka-output-settings)
- [Remote Elasticsearch output](https://www.elastic.co/docs/reference/fleet/remote-elasticsearch-output)
5. Select **Save and apply settings**.

<tip>
  If the options for editing an output are grayed out, outputs are configured outside of Fleet. For more information, refer to [Fleet settings in Kibana](https://www.elastic.co/docs/reference/kibana/configuration-reference/fleet-settings).
</tip>


## Agent binary download settings

Elastic Agents must be able to access the Elastic Artifact Registry to download binaries during upgrades. By default Elastic Agents download artifacts from the artifact registry at `https://artifacts.elastic.co/downloads/`.
For Elastic Agents that cannot access the internet, you can specify agent binary download settings, and then configure agents to download their artifacts from the alternate location. For more information about running Elastic Agents in a restricted environment, refer to [Air-gapped environments](https://www.elastic.co/docs/reference/fleet/air-gapped).
To add or edit the source of binary downloads:
1. Go to **Fleet** > **Settings**.
2. Under **Agent Binary Download**, select **Add agent binary source** or **Edit**.
3. Set the agent binary source name.
4. For **Host**, specify the address where you are hosting the artifacts repository.
5. (Optional) To make this location the default, select **Make this host the default for all agent policies**. Elastic Agents use the default location if you don’t select a different agent binary source in the agent policy.


### Configure SSL for binary downloads

<applies-to>
  - Elastic Stack: Generally available since 9.1
</applies-to>

You can optionally secure connections to your binary download source using TLS. These settings correspond to the certificates the agent uses when connecting to the download host.
The following SSL options are available when adding or editing an agent binary source:

| **UI Field**            | **Purpose**                                                               |
|-------------------------|---------------------------------------------------------------------------|
| Certificate authorities | Trusted CAs for verifying the server certificate.                         |
| Certificate             | Client certificate to use for mTLS authentication with the download host. |
| Certificate key         | Private key associated with the client certificate.                       |


## Proxies

You can specify a proxy server to be used in Fleet Server, Elastic Agent outputs, or for any agent binary download sources. For full details about proxy configuration refer to [Using a proxy server with Elastic Agent and Fleet](https://www.elastic.co/docs/reference/fleet/fleet-agent-proxy-support).

## Advanced settings

On the **Fleet** > **Settings** page, you can also configure Fleet to automatically delete unenrolled agents or to display agentless resources for inspection and diagnostics purposes.

### Delete unenrolled agents

After an Elastic Agent has been unenrolled in Fleet, a number of documents about the agent are retained in case the agent needs to be recovered at some point. You can choose to have all data related to an unenrolled agent deleted automatically. The cleanup is performed every hour.
This option can also be enabled by adding the `xpack.fleet.enableDeleteUnenrolledAgents: true` setting to the [Kibana settings file](/docs/deploy-manage/stack-settings#kib-settings).
To enable automatic deletion of unenrolled agents:
1. Go to **Fleet** > **Settings**.
2. In the **Advanced Settings** section, enable the **Delete unenrolled agents** option.


### Show agentless resources

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
</applies-to>

If you have [agentless integrations](https://www.elastic.co/docs/solutions/security/get-started/agentless-integrations) deployed, you can enable the **Show agentless resources** option to display agentless agents and policies in Fleet for inspection and diagnostics purposes. This setting is stored locally, and it's only visible to you.
To display agentless resources in the agent and agent policy lists:
1. Go to **Fleet** > **Settings**.
2. In the **Advanced Settings** section, enable **Show agentless resources**.

You can view and request diagnostics for agentless agents, but you cannot upgrade, unenroll, or reassign them.