﻿---
title: Fleet Server secrets
description: Fleet Server configuration can contain secret values. You may specify these values directly in the configuration or through secret files. You can use...
url: https://www.elastic.co/docs/reference/fleet/fleet-server-secrets
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Fleet Server secrets
Fleet Server configuration can contain secret values. You may specify these values directly in the configuration or through secret files. You can use command line arguments to pass the values or file paths when you are running under Elastic Agent, or you can use environment variables if Elastic Agent is running in a container.
For examples of how to deploy secret files, refer to our [Secret files guide](https://www.elastic.co/docs/reference/fleet/secret-files-guide).
<note>
  Stand-alone Fleet Server is under active development.
</note>


## Secret values

The following secret values may be used when configuring Fleet Server.
The configuration fragments shown below are specified either in the UI as part of the output specification or as part of the Fleet Server integration settings.
<definitions>
  <definition term="service_token">
    The `service_token` is used to communicate with Elasticsearch.
    It may be specified in the configuration directly as:
    ```yaml
    output.elasticsearch.service_token: my-service-token
    ```
    Or by a file with:
    ```yaml
    output.elasticsearch.service_token_path: /path/to/token-file
    ```
    When you are running Fleet Server under Elastic Agent, you can specify it with either the `--fleet-server-service-token` or the `--fleet-server-service-token-path` flag. See [Elastic Agent command reference](https://www.elastic.co/docs/reference/fleet/agent-command-reference) for more details.
    If you are [running Fleet Server under Elastic Agent in a container](https://www.elastic.co/docs/reference/fleet/elastic-agent-container), you can use the environment variables `FLEET_SERVER_SERVICE_TOKEN` or `FLEET_SERVER_SERVICE_TOKEN_PATH`.
  </definition>
  <definition term="TLS private key">
    Use the TLS private key to encrypt communications between Fleet Server and Elastic Agent. See [Configure SSL/TLS for self-managed Fleet Servers](https://www.elastic.co/docs/reference/fleet/secure-connections) for more details.
    Although it is not recommended, you may specify the private key directly in the configuration as:
    ```yaml
    inputs:
      - type: fleet-server
        ssl.key: |
          ----BEGIN CERTIFICATE----
          ....
          ----END CERTIFICATE----
    ```
    Alternatively, you can provide the path to the private key with the same attribute:
    ```yaml
    inputs:
      - type: fleet-server
        ssl.key: /path/to/cert.key
    ```
    When you are running Fleet Server under Elastic Agent, you can provide the private key path using with the `--fleet-server-cert-key` flag. See [Elastic Agent command reference](https://www.elastic.co/docs/reference/fleet/agent-command-reference) for more details.
    If you are [running Fleet Server under Elastic Agent in a container](https://www.elastic.co/docs/reference/fleet/elastic-agent-container), you can use the environment variable `FLEET_SERVER_CERT_KEY` to specify the private key path.
  </definition>
  <definition term="TLS private key passphrase">
    The private key passphrase is used to decrypt an encrypted private key file.
    You can specify the passphrase as a secret file in the configuration with:
    ```yaml
    inputs:
      - type: fleet-server
        ssl.key_passphrase_path: /path/to/passphrase
    ```
    When you are running Fleet Server under Elastic Agent, you can provide the passphrase path using the `--fleet-server-cert-key-passphrase` flag. See [Elastic Agent command reference](https://www.elastic.co/docs/reference/fleet/agent-command-reference) for more details.
    If you are [running Fleet Server under Elastic Agent in a container](https://www.elastic.co/docs/reference/fleet/elastic-agent-container), you can use the environment variable `FLEET_SERVER_CERT_KEY_PASSPHRASE` to specify the file path.
  </definition>
  <definition term="APM API Key">
    The APM API Key may be used to gather APM data from Fleet Server.
    You can specify it directly in the instrumentation segment of the configuration:
    ```yaml
    inputs:
      - type: fleet-server
        instrumentation.api_key: my-apm-api-key
    ```
    Or by a file with:
    ```yaml
    inputs:
      - type: fleet-server
        instrumentation.api_key_file: /path/to/apmAPIKey
    ```
    You may specify the API key by value using the environment variable `ELASTIC_APM_API_KEY`.
  </definition>
  <definition term="APM secret token">
    The APM secret token may be used to gather APM data from Fleet Server.
    You can specify the secret token directly in the instrumentation segment of the configuration:
    ```yaml
    inputs:
      - type: fleet-server
        instrumentation.secret_token: my-apm-secret-token
    ```
    Or by a file with:
    ```yaml
    inputs:
      - type: fleet-server
        instrumentation.secret_token_file: /path/to/apmSecretToken
    ```
    You may also specify the token by value using the environment variable `ELASTIC_APM_SECRET_TOKEN`.
  </definition>
</definitions>