﻿---
title: Roles and privileges
description: Use Kibana roles and privileges to grant users access to Fleet and Integrations. Fleet and integrations privileges can be set to: You can take advantage...
url: https://www.elastic.co/docs/reference/fleet/fleet-roles-privileges
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Roles and privileges
Use Kibana roles and privileges to grant users access to Fleet and Integrations.
Fleet and integrations privileges can be set to:
<definitions>
  <definition term="all">
    Grants full read-write access.
  </definition>
  <definition term="read">
    Grants read-only access.
  </definition>
  <definition term="none">
    No access is granted.
  </definition>
</definitions>

You can take advantage of these privilege settings by:
- [Using an Elasticsearch built-in role](#fleet-roles-and-privileges-built-in)
- [Creating a new role](#fleet-roles-and-privileges-create).

To configure access at a more granular level, select a custom set of privileges for individual Fleet features:
- [Customize sub-feature privileges for Fleet](#fleet-roles-and-privileges-sub-features) <applies-to>Elastic Stack: Generally available since 9.1</applies-to>


## Built-in roles

Elasticsearch comes with built-in roles that include default privileges.
<definitions>
  <definition term="editor">
    The built-in `editor` role grants these privileges, supporting full read-write access to Fleet and Integrations:
    - Fleet: `all`
    - Integrations: `all`
  </definition>
  <definition term="viewer">
    The built-in `viewer` role grants these privileges, supporting read-only access to Fleet and Integrations:
  </definition>
</definitions>

- Fleet:: `read`
- Integrations:: `read`

You can also create a new role that can be assigned to a user, in order to grant more specific levels of access to Fleet and Integrations.

## Create a new role for Fleet

To create a new role with access to Fleet and Integrations:
1. In Kibana, go to **Management → Stack Management**.
2. In the **Security** section, select **Roles**.
3. Select **Create role**.
4. Specify a name for the role.
5. Leave the Elasticsearch settings at their defaults, or refer to [Security privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges) for descriptions of the available settings.
6. In the Kibana section, select **Assign to space**.
7. In the **Spaces** menu, select **All Spaces**.
   Because many Integrations assets are shared across spaces, users need the Kibana privileges in all spaces.
8. Expand the **Management** section.
9. Set **Fleet** privileges to **All**.
10. Choose the access level that you'd like the role to have with respect to Fleet and integrations:
   1. To grant the role full access to use and manage Fleet and integrations, set both the **Fleet** and **Integrations** privileges to `All`.
   ![Kibana privileges flyout showing Fleet and Integrations access set to All](https://www.elastic.co/docs/reference/fleet/images/kibana-fleet-privileges-all.png)
   1. To create a read-only user for Fleet and Integrations, set both the **Fleet** and **Integrations** privileges to `Read`.
   ![Kibana privileges flyout showing Fleet and Integrations access set to All](https://www.elastic.co/docs/reference/fleet/images/kibana-fleet-privileges-read.png)
   1. If you'd like to define more specialized access to Fleet based on individual components, expand the **Fleet** menu and enable **Customize sub-feature privileges**.
   ![Kibana customize sub-feature privileges UI](https://www.elastic.co/docs/reference/fleet/images/kibana-fleet-privileges-enable.png)
   Any setting for individual Fleet components that you specify here takes precedence over the general `All`, `Read`, or `None` privilege set for Fleet.
   Based on your selections, access to features in the Fleet UI are enabled or disabled for the role.
   Those details are covered in the next section: [Customize access to Fleet features](#fleet-roles-and-privileges-sub-features).

After you've created a new role, you can assign it to any Elasticsearch user.
You can edit the role at any time by returning to the **Roles** page in Kibana.

## Customize sub-feature privileges for Fleet

<applies-to>
  - Elastic Stack: Generally available since 9.1
</applies-to>

Beginning with Elastic Stack version 9.1, you have more granular control when [creating a new role](#fleet-roles-and-privileges-create) or editing it. This is useful when people in your organization access Fleet for different purposes, and you need to fine-tune the components that they can view and the actions that they can perform.
The Fleet UI varies depending on the privileges granted to the role.

### Example 1: Read access for Elastic Agents

Set `Read` access for Elastic Agents only:
- Agents: `Read`
- Agent policies: `None`
- Settings: `None`

With these privileges, the Fleet UI shows only the **Agents** and **Data streams** tabs.
The **Agent policies**, **Enrollment tokens**, **Uninstall tokens**, and **Settings** tabs are unavailable.
The set of actions available for an agent are limited to viewing the agent and requesting a diagnostics bundle.
![Fleet UI showing only the Agents and Data streams tabs](https://www.elastic.co/docs/reference/fleet/images/kibana-fleet-privileges-agents-view.png)

Change the **Agents** privilege to `All` to enable the role to perform the [full set of available actions](https://www.elastic.co/docs/reference/fleet/manage-agents) on Elastic Agents.

### Example 2: Read access for all Fleet features

Set `Read` access for Elastic Agents, agent policies, and Fleet settings:
- Agents: `Read`
- Agent policies: `Read`
- Settings: `Read`

With these privileges, the Fleet UI shows the **Agents**, **Agent policies**, **Data streams**, and **Settings** tabs.
The **Enrollment tokens** and **Uninstall tokens** tabs are unavailable.
The set of actions available for an agent are limited to viewing the agent and requesting a diagnostics bundle.
You can view agent policies, but you cannot create a new policy.
![Fleet UI showing four tabs available](https://www.elastic.co/docs/reference/fleet/images/kibana-fleet-privileges-all-view.png)

You can view Fleet settings, but they are not editable.
![Fleet UI showing settings are non-editable](https://www.elastic.co/docs/reference/fleet/images/kibana-fleet-privileges-view-settings.png)


### Example 3: All access for Elastic Agents

Set `All` access for Elastic Agents only:
- Agents: `All`
- Agent policies: `Read`
- Settings: `Read`

With these privileges, the Fleet UI shows all tabs.
All Elastic Agent actions can be performed and new agents can be created. Enrollment tokens and uninstall tokens are both available.
![Fleet UI showing all tabs available](https://www.elastic.co/docs/reference/fleet/images/kibana-fleet-privileges-agent-all.png)

Access to Fleet settings is still read-only.
To enable actions such as creating a new Fleet Server, set the **Fleet Settings** privilege to `All`.

## Fleet privileges and available actions

<applies-to>
  - Elastic Stack: Generally available since 9.1
</applies-to>

This table shows the set of available actions for the `read` or `all` privilege for each Fleet feature.

| Component      | `read` privilege                                                                                                                                                                                                                                                        | `all` privilege                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
|----------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Agents         | View-only access to Elastic Agents, including:* [View a list of all agents and their status](/docs/reference/fleet/monitor-elastic-agent#view-agent-status)* [Request agent diagnostic packages](/docs/reference/fleet/monitor-elastic-agent#collect-agent-diagnostics) | Full access to manage Elastic Agents, including:* [Perform upgrades](https://www.elastic.co/docs/reference/fleet/upgrade-elastic-agent)* [Configure monitoring](https://www.elastic.co/docs/reference/fleet/monitor-elastic-agent)* [Migrate agents to a new cluster](https://www.elastic.co/docs/reference/fleet/migrate-elastic-agent)* [Unenroll agents from Fleet](https://www.elastic.co/docs/reference/fleet/unenroll-elastic-agent)* [Set the inactivity timeout](https://www.elastic.co/docs/reference/fleet/set-inactivity-timeout)* [Create and revoke enrollment tokens](https://www.elastic.co/docs/reference/fleet/fleet-enrollment-tokens) |
| Agent policies | View-only access, including:* Agent policies and settings* The integrations associated with a policy                                                                                                                                                                    | Full access to manage agent policies, including:* [Create a policy](/docs/reference/fleet/agent-policy#create-a-policy)* [Add an integration to a policy](/docs/reference/fleet/agent-policy#add-integration)* [Apply a policy](/docs/reference/fleet/agent-policy#apply-a-policy)* [Edit or delete an integration](/docs/reference/fleet/agent-policy#policy-edit-or-delete)* [Copy a policy](/docs/reference/fleet/agent-policy#copy-policy)* [Edit or delete a policy](/docs/reference/fleet/agent-policy#policy-main-settings)* [Change the output of a policy](/docs/reference/fleet/agent-policy#change-policy-output)                             |
| Fleet settings | View-only access, including:* Configured Fleet hosts* Fleet output settings* The location to download agent binaries                                                                                                                                                    | Full access to manage Fleet settings, including:* [Editing hosts](/docs/reference/fleet/fleet-settings#fleet-server-hosts-setting)* [Adding or editing outputs](/docs/reference/fleet/fleet-settings#output-settings)* [Update the location for downloading agent binaries](/docs/reference/fleet/fleet-settings#fleet-agent-binary-download-settings)                                                                                                                                                                                                                                                                                                   |