﻿---
title: Fleet enrollment tokens
description: A Fleet enrollment token (referred to as an enrollment API key in the Fleet API documentation) is an Elasticsearch API key that you use to enroll one...
url: https://www.elastic.co/docs/reference/fleet/fleet-enrollment-tokens
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Fleet enrollment tokens
A Fleet enrollment token (referred to as an `enrollment API key` in the Fleet API documentation) is an Elasticsearch API key that you use to enroll one or more Elastic Agents in Fleet. The enrollment token enrolls the Elastic Agent in a specific agent policy that defines the data to be collected by the agent and which output to use. You can use the token as many times as needed. It will remain valid until you revoke it.
The enrollment token is used for the initial communication between Elastic Agent and Fleet Server. After the initial connection request from Elastic Agent, Fleet Server passes a communication API key to the agent. This API key includes only the necessary permissions to communicate with Fleet Server. If the API key is invalid, Fleet Server stops communicating with Elastic Agent.
Depending on the output of the agent policy with which the enrollment token is associated, Fleet Server also passes additional data to Elastic Agent:
- For the Elasticsearch and remote Elasticsearch outputs, it passes an output API key.
  This API key is used to send data to Elasticsearch. It has the minimal permissions needed to ingest all the data specified by the agent policy. If the API key is invalid, Elastic Agent stops ingesting data into Elasticsearch.
- For the Kafka output, it passes authentication parameters.
  The authentication parameters are defined in the authentication settings of the Kafka output and are used by Elastic Agent to authenticate with the Kafka cluster before sending data to it.
- For the Logstash output, it passes SSL/TLS configuration details.
  The SSL/TLS configuration details such as the SSL certificate authority, the SSL certificate, and the SSL certificate key are defined during Logstash output creation. Elastic Agent uses SSL/TLS client authentication to authenticate with the Logstash pipeline before sending data to it.

<note>
  Although an API key is generated during Logstash output creation, this key is not passed to Elastic Agent by Fleet Server. If the Logstash pipeline uses the Elasticsearch output, this API key is used by Logstash to authenticate with the Elasticsearch cluster before sending data to it.
</note>


## Create enrollment tokens

Create enrollment tokens and use them to enroll Elastic Agents in specific policies.
<tip>
  When you use the Fleet UI to add an agent or create a new policy, Fleet creates an enrollment token for you automatically.
</tip>

To create an enrollment token:
1. In Kibana, go to **Management → Fleet → Enrollment tokens**.
2. Click  **Create enrollment token**. Name your token and select an agent policy.
   The token name you specify must be unique so as to avoid conflict with any existing API keys.
   ![Enrollment tokens tab in Fleet](https://www.elastic.co/docs/reference/fleet/images/create-token.png)
3. Click **Create enrollment token**.
4. In the list of tokens, click the **Show token** icon to see the token secret.
   ![Enrollment tokens tab with Show token icon highlighted](https://www.elastic.co/docs/reference/fleet/images/show-token.png)

All Elastic Agents enrolled through this token will use the selected policy unless you assign or enroll them in a different policy.
To learn how to install Elastic Agents and enroll them in Fleet, refer to [*Install Elastic Agents*](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).
<tip>
  You can use the Fleet API to get a list of enrollment tokens. For more information, refer to [Kibana Fleet APIs](https://www.elastic.co/docs/reference/fleet/fleet-api-docs).
</tip>


## Revoke enrollment tokens

You can revoke an enrollment token that you no longer wish to use to enroll Elastic Agents in an agent policy in Fleet. Revoking an enrollment token essentially invalidates the API key used by agents to communicate with Fleet Server.
To revoke an enrollment token:
1. In Fleet, click **Enrollment tokens**.
2. Find the token you want to revoke in the list and click the **Revoke token** icon.
   ![Enrollment tokens tab with Revoke token highlighted](https://www.elastic.co/docs/reference/fleet/images/revoke-token.png)
3. Click **Revoke enrollment token**. You can no longer use this token to enroll Elastic Agents. However, the currently enrolled agents will continue to function.
   To re-enroll your Elastic Agents, use an active enrollment token.

When an enrollment token is revoked it is not immediately deleted. Deletion occurs automatically after the duration specified in the Elasticsearch [`xpack.security.authc.api_key.delete.retention_period`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#api-key-service-settings-delete-retention-period) setting has expired (see [Invalidate API key API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-invalidate-api-key) for details).
Until the enrollment token has been deleted:
- The token name may not be re-used when you [create an enrollment token](#create-fleet-enrollment-tokens).
- The token continues to be visible in the Fleet UI.
- The token continues to be returned by a `GET /api/fleet/enrollment_api_keys` API request. Revoked enrollment tokens are identified as `"active": false`.