﻿---
title: Fleet and Elastic Agent restrictions for Elastic Cloud Serverless
description: If you are using Elastic Agent with Elastic Cloud Serverless, note these differences from use with Elastic Cloud Hosted and self-managed Elasticsearch:...
url: https://www.elastic.co/docs/reference/fleet/fleet-agent-serverless-restrictions
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
---

# Fleet and Elastic Agent restrictions for Elastic Cloud Serverless
## Elastic Agent

If you are using Elastic Agent with [Elastic Cloud Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless), note these differences from use with Elastic Cloud Hosted and self-managed Elasticsearch:
- A maximum of 10,000 Fleet-managed Elastic Agents can be connected to an Elastic Cloud Serverless project. This limit does not apply to standalone agents.
- The maximum supported number of Elastic Agent policies is 500.
- The minimum supported version of Elastic Agent supported for use with Elastic Cloud Serverless is 8.11.0.


### Outputs

On Serverless, you can configure new Elasticsearch outputs to use a proxy, with the restriction that the output URL is fixed. Any new Elasticsearch outputs must use the default Elasticsearch host URL.

### Upgrade

Elastic Agents are not automatically upgraded with the upgrade of the Serverless project. You can upgrade standalone or Fleet-managed Elastic Agents at your convenience.
For more information, see [Upgrade Fleet-managed Elastic Agents](https://www.elastic.co/docs/reference/fleet/upgrade-elastic-agent) and [Upgrade standalone Elastic Agents](https://www.elastic.co/docs/reference/fleet/upgrade-standalone).

## Fleet

The path to get to the Fleet application in Kibana differs across projects:
- In Elastic Cloud Hosted deployments, navigate to **Management** → **Fleet**.
- In Serverless Observability projects, navigate to **Project settings** → **Fleet**.
- In Serverless Security projects, navigate to **Assets** → **Fleet**.


## Fleet Server

Note the following restrictions with using [Fleet Server](https://www.elastic.co/docs/reference/fleet/fleet-server) on Serverless:
- On-premises Fleet Server is not currently available for use in a Serverless environment. We recommend using the hosted Fleet Server that is included and configured automatically in Serverless Observability and Security projects.
- On Serverless, you can configure Fleet Server to use a proxy, with the restriction that the Fleet Server host URL is fixed. Any new Fleet Server hosts must use the default Fleet Server host URL. Refer to [Using a proxy server with Elastic Agent and Fleet](https://www.elastic.co/docs/reference/fleet/fleet-agent-proxy-support) for more information.