﻿---
title: Elastic Agent release process
description: Elastic Agent follows a release process aligned with the broader Elastic Stack release schedule. The latest features, enhancements, and fixes are documented...
url: https://www.elastic.co/docs/reference/fleet/fleet-agent-release-process
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent release process
## Scheduled releases

Elastic Agent follows a release process aligned with the broader Elastic Stack release schedule. The latest features, enhancements, and fixes are documented in the [release notes](https://www.elastic.co/docs/release-notes/elastic-agent).

## Independent Elastic Agent releases

Independent Elastic Agent releases deliver critical fixes and updates for Elastic Agent and Elastic Defend, independently of the full stack release. This is a more conservative process than a typical patch release, and only modifies the specific Elastic Agent components needed for a targeted fix. For example, an independent Elastic Agent hotfix release for Elastic Defend would only change the endpoint-security executable, with the remaining executables being exactly those released in the previous patch.
In independent Elastic Agent releases, a build identifier is appended to the semantic version of the base release in the format `+build{yyyymmddhhmm}`, where `{yyyymmddhhmm}` is the release timestamp of the build.