﻿---
title: Using a proxy server with Elastic Agent and Fleet
description: Many enterprises secure their assets by placing a proxy server between them and the internet. The main role of the proxy server is to filter content and...
url: https://www.elastic.co/docs/reference/fleet/fleet-agent-proxy-support
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Using a proxy server with Elastic Agent and Fleet
Many enterprises secure their assets by placing a proxy server between them and the internet. The main role of the proxy server is to filter content and provide a single gateway through which all traffic traverses in and out of a data center. These proxy servers provide a various degree of functionality, security, and privacy.
Your organization’s security strategy and other considerations may require you to use a proxy server between some components in your deployment. For example, you may have a firewall rule that prevents endpoints from connecting directly to Elasticsearch. In this scenario, you can set up the Elastic Agent to connect to a proxy, then the proxy can connect to Elasticsearch through the firewall.
Support is available in Elastic Agent and Fleet for connections through HTTP Connect (HTTP 1 only) and SOCKS5 proxy servers.
<note>
  Some environments require users to authenticate with the proxy. There are no explicit settings for proxy authentication in Elastic Agent or Fleet, except the ability to pass credentials in the URL or as keys/tokens in headers, as described later.
</note>

Refer to [When to configure proxy settings](https://www.elastic.co/docs/reference/fleet/elastic-agent-proxy-config) for more detail, or jump into one of the following guides:
- [Proxy server connectivity using default host variables](https://www.elastic.co/docs/reference/fleet/host-proxy-env-vars)
- [Fleet-managed Elastic Agent connectivity using a proxy server](https://www.elastic.co/docs/reference/fleet/fleet-agent-proxy-managed)
- [Standalone Elastic Agent connectivity using a proxy server](https://www.elastic.co/docs/reference/fleet/fleet-agent-proxy-standalone)