﻿---
title: Standalone Elastic Agent connectivity using a proxy server
description: Proxy settings in the Elastic Agent policy override proxy settings specified by environment variables. This means you can specify proxy settings for Elastic...
url: https://www.elastic.co/docs/reference/fleet/fleet-agent-proxy-standalone
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Standalone Elastic Agent connectivity using a proxy server
Proxy settings in the Elastic Agent policy override proxy settings specified by environment variables. This means you can specify proxy settings for Elastic Agent that are different from host or system-level environment settings.
The following proxy settings are valid in the agent policy:

| Setting         | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
|-----------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `proxy_url`     | (string) URL of the proxy server. If set, the configured URL is used as a proxy for all connection attempts by the component. The value can be either a complete URL or a `host[:port]`, in which case the `http` scheme is assumed. Ifa value is not specified through the configuration, then proxy environment variables are used. The URL accepts optional `username` and `password` settings for authenticating with the proxy. For example: `http://<username>:<password>@<proxy host>/`. |
| `proxy_headers` | (string) Additional headers to send to the proxy during CONNECT requests. You can use this setting to pass keys/tokens required for authenticating with the proxy.                                                                                                                                                                                                                                                                                                                              |
| `proxy_disable` | (boolean) If set to `true`, all proxy settings, including the `HTTP_PROXY` and`HTTPS_PROXY` environment variables, are ignored.                                                                                                                                                                                                                                                                                                                                                                 |


## Set the proxy for communicating with Elasticsearch

For standalone agents, to set the proxy for communicating with Elasticsearch, specify proxy settings in the `elastic-agent.yml` file. For example:
```yaml
outputs:
  default:
    api_key: API-KEY
    hosts:
    - https://10.0.1.2:9200
    proxy_url: http://10.0.1.7:3128
    type: elasticsearch
```

For more information, refer to [Configure standalone Elastic Agentss](https://www.elastic.co/docs/reference/fleet/configure-standalone-elastic-agents).