﻿---
title: Generate a fingerprint of an event
description: The fingerprint processor generates a fingerprint of an event based on a specified subset of its fields. The value that is hashed is constructed as a...
url: https://www.elastic.co/docs/reference/fleet/fingerprint-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Generate a fingerprint of an event
The `fingerprint` processor generates a fingerprint of an event based on a specified subset of its fields.
The value that is hashed is constructed as a concatenation of the field name and field value separated by `|`. For example `|field1|value1|field2|value2|`.
Nested fields are supported in the following format: `"field1.field2"`, for example: `["log.path.file", "foo"]`

## Example

```yaml
  - fingerprint:
      fields: ["field1", "field2", ...]
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that your processor configurations cannot refer to fields that are created by ingest pipelines or Logstash. For more limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name             | Required | Default       | Description                                                                                                               |
|------------------|----------|---------------|---------------------------------------------------------------------------------------------------------------------------|
| `fields`         | Yes      |               | List of fields to use as the source for the fingerprint. The list will be alphabetically sorted by the processor.         |
| `ignore_missing` | No       | `false`       | Whether to ignore missing fields.                                                                                         |
| `target_field`   | No       | `fingerprint` | Field in which the generated fingerprint should be stored.                                                                |
| `method`         | No       | `sha256`      | Algorithm to use for computing the fingerprint. Must be one of: `md5`, `sha1`, `sha256`, `sha384`, `sha512`, or `xxhash`. |
| `encoding`       | No       | `hex`         | Encoding to use on the fingerprint value. Must be one of: `hex`, `base32`, or `base64`.                                   |