﻿---
title: Add tags to filter the Agents list
description: You can add tags to Elastic Agent during or after enrollment, then use the tags to filter the Agents list shown in Fleet. Tags are useful for capturing...
url: https://www.elastic.co/docs/reference/fleet/filter-agent-list-by-tags
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Add tags to filter the Agents list
You can add tags to Elastic Agent during or after enrollment, then use the tags to filter the Agents list shown in Fleet.
Tags are useful for capturing information that is specific to the installation environment, such machine type, location, operating system, environment, and so on. Tags can be any arbitrary information that will help you filter and perform operations on Elastic Agents with the same attributes.
To filter the Agents list by tag, in Kibana, go to **Fleet > Agents** and click **Tags**. Select the tags to filter on. The tags are also available in the KQL field for autocompletion.
![Agents list filtered to show agents with the staging tag](https://www.elastic.co/docs/reference/fleet/images/agent-tags.png)

If you haven’t added tags to any Elastic Agents yet, the list will be empty.

## Add, remove, rename, or delete tags in Fleet

You can use Fleet to add, remove, or rename tags applied to one or more Elastic Agents.
Want to add tags when enrolling from a host instead? See [Add tags during agent enrollment](#add-tags-at-enrollment).
To manage tags in Fleet:
1. On the **Agents** tab, select one or more agents.
2. From the **Actions** menu, click **Add / remove tags**.
   ![Screenshot of add / remove tags menu](https://www.elastic.co/docs/reference/fleet/images/add-remove-tags.png)
   <tip>
   Make sure you use the correct **Actions** menu. To manage tags for a single agent, click the ellipsis button under the **Actions** column. To manage tags for multiple agents, click the **Actions** button to open the bulk actions menu.
   </tip>
3. In the tags menu, perform an action:
   | To…                               | Do this…                                                                                                                                                                               |
   |-----------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
   | Create a new tag                  | Type the tag name and click **Create new tag…**. Notice the tag name has a check mark to show that the tag has been added to the selected agents.                                      |
   | Rename a tag                      | Hover over the tag name and click the ellipsis button. Type a new name and press Enter. The tag will be renamed in all agents that use it, even agents that are not selected.          |
   | Delete a tag                      | Hover over the tag name and click the ellipsis button. Click **Delete tag**. The tag will be deleted from all agents, even agents that are not selected.                               |
   | Add or remove a tag from an agent | Click the tag name to add or clear the check mark. In the **Tags** column, notice that the tags are added or removed. The menu only shows tags that are common to all selected agents. |


## Add tags during agent enrollment

When you install or enroll Elastic Agent in Fleet, you can specify a comma-separated list of tags to apply to the agent, then use the tags to filter the Agents list shown in Fleet.
The following command applies the `macOS` and `staging` tags during installation:
```shell
sudo ./elastic-agent install \
  --url=<Fleet Server host URL> \
  --enrollment-token=<enrollment token> \
  --tag macOS,staging
```

For the full command synopsis, refer to [elastic-agent install](/docs/reference/fleet/agent-command-reference#elastic-agent-install-command) and [elastic-agent enroll](/docs/reference/fleet/agent-command-reference#elastic-agent-enroll-command).
The following command applies the `docker` and `dev` tags to Elastic Agent running in a Docker container:
```yaml
docker run \
  --env FLEET_ENROLL=1 \
  --env FLEET_URL=<Fleet Server host URL> \
  --env FLEET_ENROLLMENT_TOKEN=<enrollment token> \
  --env ELASTIC_AGENT_TAGS=docker,dev
  --rm docker.elastic.co/elastic-agent/elastic-agent:9.3.0
```

For more information about running on containers, refer to the guides under [Install Elastic Agents in a containerized environment](https://www.elastic.co/docs/reference/fleet/install-elastic-agents-in-containers).