﻿---
title: Filesource provider
description: Watches for changes of specified files and updates the values of the variables when the content of the files changes. This allows information from the...
url: https://www.elastic.co/docs/reference/fleet/filesource-provider
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Filesource provider
Watches for changes of specified files and updates the values of the variables when the content of the files changes.
This allows information from the filesystem to be used as variables in the Elastic Agent configuration. This information is allowed only when the provider has been explicitly configured to read this information from the disk. The policy cannot just read any file, it has to be explicitly configured to allow it.
For example, the following configuration watches for changes to `file1`:
```yaml
providers:
  filesource:
    sources:
      file1:
        path: ./file1

inputs:
 - id: filestream
   type: filestream
   paths:
     - ${filesource.file1}
```