﻿---
title: Set the proxy URL of the Elastic Package Registry
description: Fleet might be unable to access the Elastic Package Registry because Kibana is behind a proxy server. Also your organization might have network traffic...
url: https://www.elastic.co/docs/reference/fleet/epr-proxy-setting
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Stack: Generally available
---

# Set the proxy URL of the Elastic Package Registry
Fleet might be unable to access the Elastic Package Registry because Kibana is behind a proxy server.
Also your organization might have network traffic restrictions that prevent Kibana from reaching the public Elastic Package Registry (EPR) endpoints, like [epr.elastic.co](https://epr.elastic.co/), to download package metadata and content. You can route traffic to the public endpoint of EPR through a network gateway, then configure proxy settings in the [Kibana configuration file](https://www.elastic.co/docs/reference/kibana/configuration-reference/fleet-settings), [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings). For example:
```yaml
xpack.fleet.registryProxyUrl: your-nat-gateway.corp.net
```

If your HTTP proxy requires authentication, you can include the credentials in the URI, such as `https://username:password@your-nat-gateway.corp.net`, only when using HTTPS.

## What information is sent to the Elastic Package Registry?

In production environments, Kibana, through the Fleet plugin, is the only service interacting with the Elastic Package Registry. Communication happens when interacting with the Integrations UI, and when upgrading Kibana. The shared information is about discovery of Elastic packages and their available versions. In general, the only deployment-specific data that is shared is the Kibana version.