﻿---
title: Env provider
description: The env provider gives access to the environment variables available to the Elastic Agent process as key-value pairs. You can then reference these values...
url: https://www.elastic.co/docs/reference/fleet/env-provider
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Env provider
The env provider gives access to the environment variables available to the Elastic Agent process as key-value pairs. You can then reference these values in the Elastic Agent configuration (for standalone agents) or in agent and integration policies in Fleet.
Using environment variables lets you keep host-specific settings and deployment-specific values out of your policies and configuration files. This is especially useful in larger setups where you want to reuse the same Elastic Agent policy but allow each host or container to supply its own settings.
Use the env provider when you want to:
- Provide host-specific or environment-specific values, such as proxy settings, regions, or service URLs.
- Reuse shared policies across agents while allowing each host, container, or service to define its own configuration through environment variables.


## Using the env provider

The env provider is enabled by default and requires no configuration. Define environment variables in your operating system, service definition, or container platform, and reference them in the Elastic Agent configuration or Fleet policy using the `${env.VAR_NAME}` syntax.
<tab-set>
  <tab-item title="Standalone Elastic Agent">
    On standalone Elastic Agent, you can reference environment variables directly in the `elastic-agent.yml` configuration file.For example, to use an environment variable as the value of the Elasticsearch host URL:
    ```yaml
    outputs:
      default:
        type: elasticsearch
        hosts: ["${env.ELASTICSEARCH_HOST}"]
    ```
    Then set the environment variable before starting Elastic Agent:
    ```shell
    ELASTICSEARCH_HOST=https://elasticsearch:9200 elastic-agent run
    ```
    The standalone agent resolves `${env.ELASTICSEARCH_HOST}` at runtime based on the environment of the agent process.
  </tab-item>

  <tab-item title="Fleet-managed Elastic Agent">
    On Fleet-managed Elastic Agent, you can define environment variables on each host running Elastic Agent and reference them in the integration or agent policy using the `${env.VAR_NAME}` syntax.For example, you can use an environment variable to set a host-specific log path in a filestream integration:
    ```yaml
    inputs:
      - type: filestream
        enabled: true
        streams:
          - paths:
              - "${env.APP_LOG_DIR}/app.log"
    ```
    Each Elastic Agent uses the env provider to resolve `${env.APP_LOG_DIR}` from the environment variables defined on the host at runtime. This allows a single policy in Fleet to adapt its behavior per host without creating multiple policies.
  </tab-item>
</tab-set>

<note>
  If you're running Elastic Agent as a Linux or Windows service, you can define environment variables in the service manifest or environment configuration. Refer to the example in [Proxy Server connectivity using default host variables](https://www.elastic.co/docs/reference/fleet/host-proxy-env-vars) for more details.For containerized deployments, refer to [Elastic Agent environment variables](https://www.elastic.co/docs/reference/fleet/agent-environment-variables) for a list of supported variables.
</note>


## Variable chaining and fallbacks

The env provider supports chaining multiple variables with fallback values. This is useful when you want to try multiple environment variables in order, with a default value when none are set.
Using fallbacks helps you create robust policies that work across different environments without requiring every variable to be defined on every host or container.
Use the following syntax:
```yaml
${env.VAR1|env.VAR2|env.VAR3|'default-value'} 
```

You can chain as many environment variables as needed, and the final fallback can be any literal string or value that the configuration field accepts.
For example:
```yaml
logging.level: ${env.LOG_LEVEL|env.DEFAULT_LOG_LEVEL|'info'}
```

This tries the `LOG_LEVEL` environment variable first, then `DEFAULT_LOG_LEVEL`, and finally defaults to `'info'` if neither variable is set.