﻿---
title: Enrollment handling for containerized agents
description: For Fleet-managed Elastic Agents that run in a containerized environment (including Docker, Kubernetes, and others), enrollment handling is managed as...
url: https://www.elastic.co/docs/reference/fleet/enrollment-handling-containerized-agent
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Enrollment handling for containerized agents
For Fleet-managed Elastic Agents that run in a containerized environment (including Docker, Kubernetes, and others), enrollment handling is managed as follows:
- **Enrollment Verification:** Elastic Agent checks the stored enrollment conditions within its container environment and re-enrolls only when necessary.
- **Unenrollment Handling:** If an Elastic Agent is unenrolled through the Fleet UI but still references a valid enrollment token provided through environment variables, it will automatically re-enroll on the next container restart.

In versions lower than 8.18, an unenrolled agent remains unenrolled and does not re-enroll, even if a valid enrollment token is still available.