﻿---
title: Enable custom settings in an agent policy
description: In certain cases it can be useful to enable custom settings that are not available in Fleet, and that override the default behavior for Elastic Agent...
url: https://www.elastic.co/docs/reference/fleet/enable-custom-policy-settings
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Enable custom settings in an agent policy
In certain cases it can be useful to enable custom settings that are not available in Fleet, and that override the default behavior for Elastic Agent.
<warning>
  Use these custom settings with caution as they are intended for special cases. We do not test all possible combinations of settings which will be passed down to the components of Elastic Agent, so it is possible that certain custom configurations can result in breakages.
</warning>

- [Configure the agent download timeout](#configure-agent-download-timeout)


## Configure the agent download timeout

You can configure the the amount of time that Elastic Agent waits for an upgrade package download to complete. This is useful in the case of a slow or intermittent network connection.
```shell
PUT kbn:/api/fleet/agent_policies/<policy-id>
{
  "name": "Test policy",
  "namespace": "default",
  "overrides": {
    "agent": {
      "download": {
        "timeout": "120s"
      }
    }
  }
}
```