﻿---
title: Configure the Elasticsearch output for Elastic Agent
description: The Elasticsearch output sends events directly to Elasticsearch by using the Elasticsearch HTTP API. Compatibility: This output works with all compatible...
url: https://www.elastic.co/docs/reference/fleet/elasticsearch-output
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure the Elasticsearch output for Elastic Agent
The Elasticsearch output sends events directly to Elasticsearch by using the Elasticsearch HTTP API.
**Compatibility:** This output works with all compatible versions of Elasticsearch. See the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_compatibility).
This example configures an Elasticsearch output called `default` in the `elastic-agent.yml` file:
```yaml
outputs:
  default:
    type: elasticsearch
    hosts: [127.0.0.1:9200]
    username: elastic
    password: changeme
```

This example is similar to the previous one, except that it uses the recommended [token-based (API key) authentication](#output-elasticsearch-apikey-authentication-settings):
```yaml
outputs:
  default:
    type: elasticsearch
    hosts: [127.0.0.1:9200]
    api_key: "my_api_key"
```

<note>
  Token-based authentication is required in an [Elastic Cloud Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless) environment.
</note>


## Elasticsearch output configuration settings

The `elasticsearch` output type supports the following settings, grouped by category. Many of these settings have sensible defaults that allow you to run Elastic Agent with minimal configuration.
- [Commonly used settings](#output-elasticsearch-commonly-used-settings)
- [Authentication settings](#output-elasticsearch-authentication-settings)
- [Compatibility setting](#output-elasticsearch-compatibility-setting)
- [Data parsing, filtering, and manipulation settings](#output-elasticsearch-data-parsing-settings)
- [HTTP settings](#output-elasticsearch-http-settings)
- [Memory queue settings](#output-elasticsearch-memory-queue-settings)
- [Performance tuning settings](#output-elasticsearch-performance-tuning-settings)


## Commonly used settings

<definitions>
  <definition term="enabled">
    (boolean) Enables or disables the output. If set to `false`, the output is disabled.
    **Default:** `true`
  </definition>
  <definition term="hosts">
    (list) The list of Elasticsearch nodes to connect to. The events are distributed to these nodes in round robin order. If one node becomes unreachable, the event is automatically sent to another node. Each Elasticsearch node can be defined as a `URL` or `IP:PORT`. For example: `http://192.15.3.2`, `https://es.found.io:9230` or `192.24.3.2:9300`. If no port is specified, `9200` is used.
    <note>
      When a node is defined as an `IP:PORT`, the *scheme* and *path* are taken from the `protocol` and `path` settings.
    </note>
    ```yaml
    outputs:
      default:
        type: elasticsearch
        hosts: ["10.45.3.2:9220", "10.45.3.1:9230"] 
        protocol: https
        path: /elasticsearch
    ```
    Note that Elasticsearch Nodes in the [Elastic Cloud Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless) environment are exposed on port 443.
  </definition>
  <definition term="protocol">
    (string) The name of the protocol Elasticsearch is reachable on. The options are: `http` or `https`. The default is `http`. However, if you specify a URL for `hosts`, the value of `protocol` is overridden by whatever scheme you specify in the URL.
  </definition>
  <definition term="proxy_disable">
    (boolean) If set to `true`, all proxy settings, including `HTTP_PROXY` and `HTTPS_PROXY` variables, are ignored.
    **Default:** `false`
  </definition>
  <definition term="proxy_headers">
    (string) Additional headers to send to proxies during CONNECT requests.
  </definition>
  <definition term="proxy_url">
    (string) The URL of the proxy to use when connecting to the Elasticsearch servers. The value may be either a complete URL or a `host[:port]`, in which case the `http` scheme is assumed. If a value is not specified through the configuration file then proxy environment variables are used. See the [Go documentation](https://golang.org/pkg/net/http/#ProxyFromEnvironment) for more information about the environment variables.
  </definition>
</definitions>


## Authentication settings

When sending data to a secured cluster through the `elasticsearch` output, Elastic Agent can use any of the following authentication methods:
- [Basic authentication credentials](#output-elasticsearch-basic-authentication-settings)
- [Token-based (API key) authentication](#output-elasticsearch-apikey-authentication-settings)
- [Public Key Infrastructure (PKI) certificates](#output-elasticsearch-pki-certs-authentication-settings)
- [Kerberos](#output-elasticsearch-kerberos-authentication-settings)


### Basic authentication credentials

```yaml
outputs:
  default:
    type: elasticsearch
    hosts: ["https://myEShost:9200"]
    username: "your-username"
    password: "your-password"
```

<definitions>
  <definition term="password">
    (string) The basic authentication password for connecting to Elasticsearch.
  </definition>
  <definition term="username">
    (string) The basic authentication username for connecting to Elasticsearch.
    This user needs the privileges required to publish events to Elasticsearch.
    Note that in an [Elastic Cloud Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless) environment you need to use [token-based (API key) authentication](#output-elasticsearch-apikey-authentication-settings).
  </definition>
</definitions>


### Token-based (API key) authentication

```yaml
outputs:
  default:
    type: elasticsearch
    hosts: ["https://myEShost:9200"]
    api_key: "KnR6yE41RrSowb0kQ0HWoA"
```

<definitions>
  <definition term="api_key">
    (string) Instead of using a username and password, you can use [API keys](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys) to secure communication with Elasticsearch. The value must be the ID of the API key and the API key joined by a colon: `id:api_key`. Token-based authentication is required in an [Elastic Cloud Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless) environment.
  </definition>
</definitions>


### Public Key Infrastructure (PKI) certificates

```yaml
outputs:
  default:
    type: elasticsearch
    hosts: ["https://myEShost:9200"]
    ssl.certificate: "/etc/pki/client/cert.pem"
    ssl.key: "/etc/pki/client/cert.key"
```

For a list of available settings, refer to [SSL/TLS](https://www.elastic.co/docs/reference/fleet/elastic-agent-ssl-configuration), specifically the settings under [Table 7, Common configuration options](/docs/reference/fleet/elastic-agent-ssl-configuration#common-ssl-options) and [Table 8, Client configuration options](/docs/reference/fleet/elastic-agent-ssl-configuration#client-ssl-options).

### Kerberos

The following encryption types are supported:
- aes128-cts-hmac-sha1-96
- aes128-cts-hmac-sha256-128
- aes256-cts-hmac-sha1-96
- aes256-cts-hmac-sha384-192
- des3-cbc-sha1-kd
- rc4-hmac

Example output config with Kerberos password-based authentication:
```yaml
outputs:
  default:
    type: elasticsearch
    hosts: ["http://my-elasticsearch.elastic.co:9200"]
    kerberos.auth_type: password
    kerberos.username: "elastic"
    kerberos.password: "changeme"
    kerberos.config_path: "/etc/krb5.conf"
    kerberos.realm: "ELASTIC.CO"
```

The service principal name for the Elasticsearch instance is constructed from these options. Based on this configuration, the name would be:
`HTTP/my-elasticsearch.elastic.co@ELASTIC.CO`
<definitions>
  <definition term="kerberos.auth_type">
    (string) The type of authentication to use with Kerberos KDC:
    <definitions>
      <definition term="password">
        When specified, also set `kerberos.username` and `kerberos.password`.
      </definition>
      <definition term="keytab">
        When specified, also set `kerberos.username` and `kerberos.keytab`. The keytab must contain the keys of the selected principal, or authentication fails.
      </definition>
    </definitions>
    **Default:** `password`
  </definition>
  <definition term="kerberos.config_path">
    (string) Path to the `krb5.conf`. Elastic Agent uses this setting to find the Kerberos KDC to retrieve a ticket.
  </definition>
  <definition term="kerberos.enabled">
    (boolean) Enables or disables the Kerberos configuration.
    <note>
      Kerberos settings are disabled if either `enabled` is set to `false` or the `kerberos` section is missing.
    </note>
  </definition>
  <definition term="kerberos.enable_krb5_fast">
    (boolean) If `true`, enables Kerberos FAST authentication. This may conflict with some Active Directory installations.
    **Default:** `false`
  </definition>
  <definition term="kerberos.keytab">
    (string) If `kerberos.auth_type` is `keytab`, provide the path to the keytab of the selected principal.
  </definition>
  <definition term="kerberos.password">
    (string) If `kerberos.auth_type` is `password`, provide a password for the selected principal.
  </definition>
  <definition term="kerberos.realm">
    (string) Name of the realm where the output resides.
  </definition>
  <definition term="kerberos.username">
    (string) Name of the principal used to connect to the output.
  </definition>
</definitions>


### Compatibility setting

<definitions>
  <definition term="allow_older_versions">
    Allow Elastic Agent to connect and send output to an Elasticsearch instance that is running an earlier version than the agent version.
    Note that this setting does not affect Elastic Agent's ability to connect to Fleet Server. Fleet Server will not accept a connection from an agent at a later major or minor version. It will accept a connection from an agent at a later patch version. For example, an Elastic Agent at version 8.14.3 can connect to a Fleet Server on version 8.14.0, but an agent at version 8.15.0 or later is not able to connect.
    **Default:** `true`
  </definition>
  <definition term="status_reporting.enabled">
    (boolean) Whether status reporting is enabled for this output. When disabled, the output does not change its health status if there is a connectivity problem.
    **Default:** `true`
  </definition>
</definitions>


### Data parsing, filtering, and manipulation settings

Settings used to parse, filter, and transform data.
<definitions>
  <definition term="escape_html">
    (boolean) Configures escaping of HTML in strings. Set to `true` to enable escaping.
    **Default:** `false`
  </definition>
  <definition term="pipeline">
    (string) A format string value that specifies the [ingest pipeline](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines) to write events to.
    ```yaml
    outputs:
      default:
        type: elasticsearch
        hosts: ["http://localhost:9200"]
        pipeline: my_pipeline_id
    ```
    You can set the ingest pipeline dynamically by using a format string to access any event field. For example, this configuration uses a custom field, `fields.log_type`, to set the pipeline for each event:
    ```yaml
    outputs:
      default:
        type: elasticsearch
        hosts: ["http://localhost:9200"]
        pipeline: "%{[fields.log_type]}_pipeline"
    ```
    With this configuration, all events with `log_type: normal` are sent to a pipeline named `normal_pipeline`, and all events with `log_type: critical` are sent to a pipeline named `critical_pipeline`.
    <tip>
      To learn how to add custom fields to events, see the `fields` option.
    </tip>
    See the `pipelines` setting for other ways to set the ingest pipeline dynamically.
  </definition>
  <definition term="pipelines">
    An array of pipeline selector rules. Each rule specifies the [ingest pipeline](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines) to use for events that match the rule. During publishing, Elastic Agent uses the first matching rule in the array. Rules can contain conditionals, format string-based fields, and name mappings. If the `pipelines` setting is missing or no rule matches, the `pipeline` setting is used.
    Rule settings:
    <definitions>
      <definition term="pipeline">
        The pipeline format string to use. If this string contains field references, such as `%{[fields.name]}`, the fields must exist, or the rule fails.
      </definition>
      <definition term="mappings">
        A dictionary that takes the value returned by `pipeline` and maps it to a new name.
      </definition>
      <definition term="default">
        The default string value to use if `mappings` does not find a match.
      </definition>
      <definition term="when">
        A condition that must succeed in order to execute the current rule.
      </definition>
    </definitions>
    All the conditions supported by processors are also supported here.
    The following example sends events to a specific pipeline based on whether the `message` field contains the specified string:
    ```yaml
    outputs:
      default:
        type: elasticsearch  hosts: ["http://localhost:9200"]
        pipelines:
          - pipeline: "warning_pipeline"
            when.contains:
              message: "WARN"
          - pipeline: "error_pipeline"
            when.contains:
              message: "ERR"
    ```
    The following example sets the pipeline by taking the name returned by the `pipeline` format string and mapping it to a new name that’s used for the pipeline:
    ```yaml
    outputs:
      default:
        type: elasticsearch
        hosts: ["http://localhost:9200"]
        pipelines:
          - pipeline: "%{[fields.log_type]}"
            mappings:
              critical: "sev1_pipeline"
              normal: "sev2_pipeline"
            default: "sev3_pipeline"
    ```
    With this configuration, all events with `log_type: critical` are sent to `sev1_pipeline`, all events with `log_type: normal` are sent to a `sev2_pipeline`, and all other events are sent to `sev3_pipeline`.
  </definition>
</definitions>


## HTTP settings

Settings that modify the HTTP requests sent to Elasticsearch.
<definitions>
  <definition term="headers">
    Custom HTTP headers to add to each request created by the Elasticsearch output.
    Example:
    ```yaml
    outputs:
      default:
        type: elasticsearch
        headers:
          X-My-Header: Header contents
    ```
    Specify multiple header values for the same header name by separating them with a comma.
  </definition>
  <definition term="parameters">
    Dictionary of HTTP parameters to pass within the URL with index operations.
  </definition>
  <definition term="path">
    (string) An HTTP path prefix that is prepended to the HTTP API calls. This is useful for the cases where Elasticsearch listens behind an HTTP reverse proxy that exports the API under a custom prefix.
  </definition>
</definitions>


## Memory queue settings

The memory queue keeps all events in memory.
The memory queue waits for the output to acknowledge or drop events. If the queue is full, no new events can be inserted into the memory queue. Only after the signal from the output will the queue free up space for more events to be accepted.
The memory queue is controlled by the parameters `flush.min_events` and `flush.timeout`. `flush.min_events` gives a limit on the number of events that can be included in a single batch, and `flush.timeout` specifies how long the queue should wait to completely fill an event request. If the output supports a `bulk_max_size` parameter, the maximum batch size will be the smaller of `bulk_max_size` and `flush.min_events`.
`flush.min_events` is a legacy parameter, and new configurations should prefer to control batch size with `bulk_max_size`. As of 8.13, there is never a performance advantage to limiting batch size with `flush.min_events` instead of `bulk_max_size`.
In synchronous mode, an event request is always filled as soon as events are available, even if there are not enough events to fill the requested batch. This is useful when latency must be minimized. To use synchronous mode, set `flush.timeout` to 0.
For backwards compatibility, synchronous mode can also be activated by setting `flush.min_events` to 0 or 1. In this case, batch size will be capped at 1/2 the queue capacity.
In asynchronous mode, an event request will wait up to the specified timeout to try and fill the requested batch completely. If the timeout expires, the queue returns a partial batch with all available events. To use asynchronous mode, set `flush.timeout` to a positive duration, for example 5s.
This sample configuration forwards events to the output when there are enough events to fill the output’s request (usually controlled by `bulk_max_size`, and limited to at most 512 events by `flush.min_events`), or when events have been waiting for
```yaml
  queue.mem.events: 4096
  queue.mem.flush.min_events: 512
  queue.mem.flush.timeout: 5s
```

<definitions>
  <definition term="queue.mem.events">
    The number of events the queue can store. This value should be evenly divisible by the smaller of `queue.mem.flush.min_events` or `bulk_max_size` to avoid sending partial batches to the output.
    **Default:** `3200 events`
  </definition>
  <definition term="queue.mem.flush.min_events">
    `flush.min_events` is a legacy parameter, and new configurations should prefer to control batch size with `bulk_max_size`. As of 8.13, there is never a performance advantage to limiting batch size with `flush.min_events` instead of `bulk_max_size`
    **Default:** `1600 events`
  </definition>
  <definition term="queue.mem.flush.timeout">
    (int) The maximum wait time for `queue.mem.flush.min_events` to be fulfilled. If set to 0s, events are available to the output immediately.
    **Default:** `10s`
  </definition>
</definitions>


## Performance tuning settings

Settings that may affect performance when sending data through the Elasticsearch output.
Use the `preset` option to automatically configure the group of performance tuning settings to optimize for `throughput`, `scale`, `latency`, or you can select a `balanced` set of performance specifications.
The performance tuning `preset` values take precedence over any settings that may be defined separately. If you want to change any setting, set `preset` to `custom` and specify the performance tuning settings individually.
<definitions>
  <definition term="backoff.init">
    (string) The number of seconds to wait before trying to reconnect to Elasticsearch after a network error. After waiting `backoff.init` seconds, Elastic Agent tries to reconnect. If the attempt fails, the backoff timer is increased exponentially up to `backoff.max`. After a successful connection, the backoff timer is reset.
    **Default:** `1s`
  </definition>
  <definition term="backoff.max">
    (string) The maximum number of seconds to wait before attempting to connect to Elasticsearch after a network error.
    **Default:** `60s`
  </definition>
  <definition term="bulk_max_size">
    (int) The maximum number of events to bulk in a single Elasticsearch bulk API index request.
    Events can be collected into batches. Elastic Agent will split batches larger than `bulk_max_size` into multiple batches.
    Specifying a larger batch size can improve performance by lowering the overhead of sending events. However big batch sizes can also increase processing times, which might result in API errors, killed connections, timed-out publishing requests, and, ultimately, lower throughput.
    Setting `bulk_max_size` to values less than or equal to 0 turns off the splitting of batches. When splitting is disabled, the queue decides on the number of events to be contained in a batch.
    **Default:** `1600`
  </definition>
  <definition term="compression_level">
    (int) The gzip compression level. Set this value to `0` to disable compression. The compression level must be in the range of `1` (best speed) to `9` (best compression).
    Increasing the compression level reduces network usage but increases CPU usage.
    **Default:** `1`
  </definition>
  <definition term="max_retries">
    (int) The number of times to retry publishing an event after a publishing failure. After the specified number of retries, the events are typically dropped.
    Set `max_retries` to a value less than 0 to retry until all events are published.
    **Default:** `3`
  </definition>
  <definition term="preset">
    Configures the full group of [performance tuning settings](#output-elasticsearch-performance-tuning-settings) to optimize your Elastic Agent performance when sending data to an Elasticsearch output.
    Refer to [Performance tuning settings](/docs/reference/fleet/es-output-settings#es-output-settings-performance-tuning-settings) for a table showing the group of values associated with any preset, and another table showing EPS (events per second) results from testing the different preset options.
    Performance tuning preset settings:
    <definitions>
      <definition term="balanced">
        Configure the default tuning setting values for "out-of-the-box" performance.
      </definition>
      <definition term="throughput">
        Optimize the Elasticsearch output for throughput.
      </definition>
      <definition term="scale">
        Optimize the Elasticsearch output for scale.
      </definition>
      <definition term="latency">
        Optimize the Elasticsearch output to reduce latence.
      </definition>
      <definition term="custom">
        Use the `custom` option to fine-tune the performance tuning settings individually.
      </definition>
    </definitions>
    **Default:** `balanced`
  </definition>
  <definition term="timeout">
    (string) The HTTP request timeout in seconds for the Elasticsearch request.
    **Default:** `90s`
  </definition>
  <definition term="worker">
    (int) The number of workers per configured host publishing events. Example: If you have two hosts and three workers, in total six workers are started (three for each host).
    **Default:** `1`
  </definition>
</definitions>