﻿---
title: Run Elastic Agent without administrative privileges
description: Beginning with Elastic Stack version 8.15, Elastic Agent is no longer required to be run by a user with superuser privileges. You can now run agents in...
url: https://www.elastic.co/docs/reference/fleet/elastic-agent-unprivileged
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Run Elastic Agent without administrative privileges
Beginning with Elastic Stack version 8.15, Elastic Agent is no longer required to be run by a user with superuser privileges. You can now run agents in an `unprivileged` mode that does not require `root` access on Linux or macOS, or `admin` access on Windows. Being able to run agents without full administrative privileges is often a requirement in organizations where this kind of access is often limited.
<note>
  Unprivileged mode is not supported for Elastic Agent installed using RPM or DEB packages. To use unprivileged mode on Linux, you must install Elastic Agent using the tarball (`.tar.gz`) distribution.
</note>

In general, agents running without full administrative privileges will perform and behave exactly as those run by a superuser. There are certain integrations and data streams that are not available, however. If an integration requires root access, this is [indicated on the integration main page](#unprivileged-integrations).
You can also [change the privilege mode](#unprivileged-change-mode) of an Elastic Agent after it has been installed.
Refer to [Agent and dashboard behaviors in unprivileged mode](#unprivileged-command-behaviors) and [Run Elastic Agent in `unprivileged` mode](#unprivileged-running) for the requirements and steps associated with running an agent without full `root` or `admin` superuser privileges.
- [Run Elastic Agent in `unprivileged` mode](#unprivileged-running)
- [Agent and dashboard behaviors in unprivileged mode](#unprivileged-command-behaviors)
- [Using Elastic integrations](#unprivileged-integrations)
- [Viewing an Elastic Agent privilege mode](#unprivileged-view-mode)
- [Changing an Elastic Agent's privilege mode](#unprivileged-change-mode)
- [Using `unprivileged` mode with a pre-existing user and group](#unprivileged-preexisting-user)


## Run Elastic Agent in `unprivileged` mode

To run Elastic Agent without administrative privileges you use exactly the same commands that you use for Elastic Agent otherwise, with one exception. When you run the [`elastic-agent install`](/docs/reference/fleet/agent-command-reference#elastic-agent-install-command) command, add the `--unprivileged` flag. For example:
<tab-set>
  <tab-item title="Linux/macOS">
    ```shell
    sudo elastic-agent install \
      --url=https://cedd4e0e21e240b4s2bbbebdf1d6d52f.fleet.eu-west-1.aws.cld.elstc.co:443 \
      --enrollment-token=NEFmVllaa0JLRXhKebVKVTR5TTI6N2JaVlJpSGpScmV0ZUVnZVlRUExFQQ== \
      --unprivileged
    ```
  </tab-item>

  <tab-item title="Windows">
    From PowerShell:
    ```shell
    elastic-agent install `
      --url=https://cedd4e0e21e240b4s2bbbebdf1d6d52f.fleet.eu-west-1.aws.cld.elstc.co:443 `
      --enrollment-token=NEFmVllaa0JLRXhKebVKVTR5TTI6N2JaVlJpSGpScmV0ZUVnZVlRUExFQQ== `
      --unprivileged
    ```
  </tab-item>
</tab-set>


### Considerations

If you installed Elastic Agent using an RPM or DEB package, the commands related to unprivileged mode will not work. To use unprivileged mode on Linux, you must install Elastic Agent using the tarball (`.tar.gz`) distribution.
When running Elastic Agent in `unprivileged` mode on Linux systems, consider the following:
- You must use `sudo` to run the `elastic-agent install` command because only the root user can install new services. After Elastic Agent is installed with the `--unprivileged` flag, the service does not run as root, and you can run Elastic Agent commands without being the root user.
- When the Elastic Agent is in `unprivileged` mode, using `sudo` with Elastic Agent commands can cause [an error](/docs/troubleshoot/ingest/fleet/common-problems#agent-sudo-error) because the agent does not have the required privileges. To avoid this, run commands as the user that runs the Elastic Agent service by using `sudo -u elastic-agent-user`.
- For files that grant access to users in the `elastic-agent` group, you can also run commands as any user that belongs to that group. However, some commands are only available to the user that runs the service (`elastic-agent-user`). For example, `elastic-agent inspect` must be run as that user:
  ```shell
  sudo -u elastic-agent-user elastic-agent inspect
  ```


## Agent and dashboard behaviors in unprivileged mode

In addition to the [integrations that are not available](#unprivileged-integrations) when Elastic Agent is run in unpriviledged mode, certain data streams are also not available. The following tables show, for different operating systems, the impact when the agent does not have full administrative privileges. In most cases the limitations can be mediated by granting permissions for a user or group to the files indicated.

| Action                                                    | Behavior in unprivileged mode                                                                                                                                             | Resolution                                                                                                                                                                                                                                        |
|-----------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Run Elastic Agent with the System integration             | Log file error: `Unexpected file opening error: Failed opening /var/log/system.log: open /var/log/system.log: permission denied`.                                         | Give read permission to the `elastic-agent` group for the `/var/log/system.log` file to fix this error.                                                                                                                                           |
| Run Elastic Agent with the System integration             | On the `[Logs System] Syslog` dashboard, the `Syslog events by hostname`, `Syslog hostnames and processes` and `Syslog logs` visualizations are are missing data.         | Give read permission to the `elastic-agent` group for the `/var/log/system.log` file to fix the missing visualizations.                                                                                                                           |
| Run Elastic Agent with the System integration             | On the `[Metrics System] Host overview` dashboard, only the processes run by the `elastic-agent-user` user are shown in the CPU and memory usage lists.                   | To fix the missing processes in the visualization lists you can add add the `elastic-agent-user` user to the system `admin` group. While this mitigates the issue, it also grants `elastic-agent user` with more permissions than may be desired. |
| Run Elastic Agent and access the Elastic Agent dashboards | On the `[Elastic Agent] Agents info` dashboard, visualizations including `Most Active Agents` and `Integrations per Agent` are missing data.                              | To fix the missing data in the visualizations you can add add the `elastic-agent-user` user to the system `admin` group. While this mitigates the issue it also grants `elastic-agent user` with more permissions than may be desired.            |
| Run Elastic Agent and access the Elastic Agent dashboards | On the `[Elastic Agent] Integrations` dashboard, visualizations including `Integration Errors Table`, `Events per integration` and `Integration Errors` are missing data. | To fix the missing data in the visualizations you can add add the `elastic-agent-user` user to the system `admin` group. While this mitigates the issue it also grants `elastic-agent user` with more permissions than may be desired.            |


| Action                                                    | Behavior in unprivileged mode                                                                                                                                                                                                                                                              | Resolution                                                                                                                                                                                                                                                       |
|-----------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Run Elastic Agent with the System integration             | Log file error: `[elastic_agent.filebeat][error] Harvester could not be started on new file: /var/log/auth.log.1, Err: error setting up harvester: Harvester setup failed. Unexpected file opening error: Failed opening /var/log/auth.log.1: open /var/log/auth.log.1: permission denied` | To avoid the error you can add add the `elastic-agent-user` user to the `adm` group. While this mitigates the issue it also grants `elastic-agent user` with more permissions than may be desired.                                                               |
| Run Elastic Agent with the System integration             | Log file error: `[elastic_agent.metricbeat][error] error getting filesystem usage for /run/user/1000/gvfs: error in Statfs syscall: permission denied`                                                                                                                                     | To avoid the error you can add add the `elastic-agent-user` user to the `adm` group. While this mitigates the issue it also grants `elastic-agent user` with more permissions than may be desired.                                                               |
| Run Elastic Agent with the System integration             | On the `[Logs System] Syslog` dashboard, the `Syslog events by hostname`, `Syslog hostnames and processes` and `Syslog logs` visualizations are are missing data.                                                                                                                          | To fix the missing data in the visualizations you can add add the `elastic-agent-user` user to the `adm` group. While this mitigates the issue it also grants `elastic-agent user` with more permissions than may be desired.                                    |
| Run Elastic Agent and access the Elastic Agent dashboards | On the `[Elastic Agent] Agents info` dashboard, visualizations including `Most Active Agents` and `Integrations per Agent` are missing data.                                                                                                                                               | Giving read permission to the `elastic-agent` group for the `/var/log/system.log` file will partially fix the visualizations, but errors may still occur because the `elastic-agent-user` does not have read access to files in the `/run/user/1000/` directory. |
| Run Elastic Agent and access the Elastic Agent dashboards | On the `[Elastic Agent] Integrations` dashboard, visualizations including `Integration Errors Table`, `Events per integration` and `Integration Errors` are missing data.                                                                                                                  | Give read permission to the `elastic-agent` group for the `/var/log/system.log` file to fix the missing visualizations.                                                                                                                                          |


| Action                                        | Behavior in unprivileged mode                                                                                       | Resolution                                                                                                                                                                                                                                                                                                                                                                                                     |
|-----------------------------------------------|---------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Run Elastic Agent with the System integration | Log file error: `failed to open Windows Event Log channel "Security": Access is denied`                             | Add the `elastic-agent-user` user to the `Event Log Users` group to fix this error.                                                                                                                                                                                                                                                                                                                            |
| Run Elastic Agent with the System integration | Log file error: `cannot open new key in the registry in order to enable the performance counters: Access is denied` | Update the permissions for the `HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\PartMgr` registry to fix this error.                                                                                                                                                                                                                                                                                      |
| Run Elastic Agent with the System integration | Most of the System and Elastic Agent dashboard visualizations are missing all data.                                 | Add the `elastic-agent-user` user to the `Event Log Users` group and update the permissions for the `HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\PartMgr` registry to fix the missing visualizations.The `elastic-agent-user` user may still not have access to all processes, so the lists in the `Top processes by CPU usage` and `Top processes by memory usage` visualizations may be incomplete. |
| Run Elastic Agent with the System integration | On the `[Metrics System] Host overview` dashboard, the `Disk usage` visualizations are missing data.                | This occurs because direct access to the disk or a volume is restricted and not available to users without administrative privileges. Refer to [Running with Special Privileges](https://learn.microsoft.com/en-us/windows/win32/secbp/running-with-special-privileges) in the Microsoft documentation for details.                                                                                            |


## Using Elastic integrations

Most Elastic integrations support running Elastic Agent in unprivileged mode. For the exceptions, any integration that requires Elastic Agent to have root privileges has the requirement indicated at the top of the integration page in Kibana:
![Elastic Defend integration page showing root requirement](https://www.elastic.co/docs/reference/fleet/images/integration-root-requirement.png)

As well, a warning is displayed in Kibana if you try to add an integration that requires root privileges to an Elastic Agent policy that has agents enrolled in unprivileged mode.
![Warning indicating that root privileged agent is required for an integration](https://www.elastic.co/docs/reference/fleet/images/unprivileged-agent-warning.png)

Examples of integrations that require Elastic Agent to have administrative privileges are:
- [Elastic Defend](https://www.elastic.co/docs/reference/integrations/endpoint)
- [Auditd Manager](https://www.elastic.co/docs/reference/integrations/auditd_manager)
- [File Integrity Monitoring](https://www.elastic.co/docs/reference/integrations/fim)
- [Network Packet Capture](https://www.elastic.co/docs/reference/integrations/network_traffic)
- [System Audit](https://www.elastic.co/docs/reference/integrations/system_audit)
- [Universal Profiling Agent](https://www.elastic.co/docs/reference/integrations/profiler_agent)


## Viewing an Elastic Agent privilege mode

The **Agent details** page shows you the privilege mode for any running Elastic Agent.
To view the status of an Elastic Agent:
1. In Fleet, open the **Agents** tab.
2. Select an agent and click **View agent** in the actions menu.
3. The **Agent details** tab shows whether the agent is running in `privileged` or `unprivileged` mode.
   ![Agent details tab showing the agent is running as non-root](https://www.elastic.co/docs/reference/fleet/images/agent-privilege-mode.png)

As well, for any Elastic Agent policy you can view the number of agents that are currently running in privileged or unprivileged mode:
1. In Fleet, open the **Agent policies** tab.
2. Click the agent policy to view the policy details.

The number of agents enrolled with the policy is shown. Hover over the link to view the number of privileged and unpriviled agents.
![Agent policy tab showing 1 unprivileged agent and 0 privileged enrolled agents](https://www.elastic.co/docs/reference/fleet/images/privileged-and-unprivileged-agents.png)

In the event that the Elastic Agent policy has integrations installed that require root privileges, but there are agents running without root privileges, this is shown in the tooltip.
![Agent policy tab showing 1 unprivileged agent and 0 privileged enrolled agents](https://www.elastic.co/docs/reference/fleet/images/root-integration-and-unprivileged-agents.png)


## Changing an Elastic Agent's privilege mode

For any installed Elastic Agent you can change the mode that it's running in by running the `privileged` or `unprivileged` subcommand.
<tip applies-to="Elastic Cloud Serverless: Generally available, Elastic Stack: Generally available since 9.3">
  When managing multiple agents, you can [remove agents' elevated privileges centrally using the Fleet UI or API](https://www.elastic.co/docs/reference/fleet/remove-agent-elevated-privileges).
</tip>

<note>
  Changing privilege modes is not supported for Elastic Agent installed using RPM or DEB packages.
</note>

Change mode from privileged to unprivileged:
<tab-set>
  <tab-item title="Linux/macOS">
    ```shell
    sudo elastic-agent unprivileged
    ```
  </tab-item>

  <tab-item title="Windows">
    ```shell
    elastic-agent unprivileged
    ```
  </tab-item>
</tab-set>

Changing to `unprivileged` mode is prevented if the agent is currently enrolled in a policy that includes an integration that requires administrative access, such as the Elastic Defend integration.
Change mode from unprivileged to privileged:
<tab-set>
  <tab-item title="Linux/macOS">
    ```shell
    sudo elastic-agent privileged
    ```
  </tab-item>

  <tab-item title="Windows">
    ```shell
    elastic-agent privileged
    ```
  </tab-item>
</tab-set>

When an agent is running in `unprivileged` mode, if it doesn’t have the right level of privilege to read a data source, you can also adjust the agent’s privileges by adding `elastic-agent-user` to the user group that has privileges to read the data source.
As background, when you run Elastic Agent in `unprivileged` mode, one user and one group are created on the host. The same names are used for all operating systems:
- `elastic-agent-user`: The user that is created and that the Elastic Agent service runs as.
- `elastic-agent`: The group that is created. Any user in this group has access to control and communicate over the control protocol to the Elastic Agent daemon.

For example:
1. When you install Elastic Agent with the `--unprivileged` setting, the `elastic-agent-user` user and the `elastic-agent` group are created automatically.
2. If you then want your user `myuser` to be able to run an Elastic Agent command such as `elastic-agent status`, add the `myuser` user to the `elastic-agent` group.
3. Then, once added to the group, the `elastic-agent status` command will work. Prior to that, the user `myuser` running the command will result in a permission error that indicates a problem communicating with the control socket.


## Using `unprivileged` mode with a pre-existing user and group

In certain cases you may want to install Elastic Agent in `unprivileged` mode, with the agent running as a pre-existing user or as part of a pre-existing group. For example, on a Windows system you may have a service account in Active Directory and you'd like Elastic Agent to run under that account.
<note>
  This functionality is not supported for Elastic Agent installed using RPM or DEB packages.
</note>

<admonition title="Active Directory to determine user group" applies-to="Elastic Stack: Preview">
  The ability to interface with Active Directory to determine the user group is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.
</admonition>

<note>
  On Windows, the `--password` parameter is required when specifying a custom user account.On Linux and macOS, the `--user` and `--group` parameters are optional:
  - If you omit `--user`, Elastic Agent uses (or creates) the default unprivileged user (`elastic-agent-user`).
  - If you specify only `--group`, the agent runs unprivileged in the requested group using the default user.
</note>

To install Elastic Agent in `unprivileged` mode as a specific user or group, use the following commands:
<tab-set>
  <tab-item title="Linux/macOS">
    To install with a specific user:
    ```shell
    sudo elastic-agent install --unprivileged --user="username"
    ```
    To install with a specific group:
    ```shell
    sudo elastic-agent install --unprivileged --group="groupname"
    ```
    To install with both a specific user and group:
    ```shell
    sudo elastic-agent install --unprivileged --user="username" --group="groupname"
    ```
  </tab-item>

  <tab-item title="Windows">
    To install as a specific user:
    ```shell
    elastic-agent install --unprivileged --user="my.domain\username" --password="mypassword"
    ```
    To install as part of a specific group:
    ```shell
    elastic-agent install --unprivileged --group="my.domain\groupname"
    ```
    To install with both a specific user and group:
    ```shell
    elastic-agent install --unprivileged --user="my.domain\username" --password="mypassword" --group="my.domain\groupname"
    ```
  </tab-item>
</tab-set>

Alternatively, if you have Elastic Agent already installed with administrative privileges, you can change the agent to use `unprivileged` mode and to run as a specific user or in a specific group.
<tab-set>
  <tab-item title="Linux/macOS">
    To change to a specific user:
    ```shell
    sudo elastic-agent unprivileged --user="username"
    ```
    To change to a specific group:
    ```shell
    sudo elastic-agent unprivileged --group="groupname"
    ```
  </tab-item>

  <tab-item title="Windows">
    To change to a specific user:
    ```shell
    elastic-agent unprivileged --user="my.domain\username" --password="mypassword"
    ```
    To change to a specific group:
    ```shell
    elastic-agent unprivileged --group="my.domain\groupname"
    ```
  </tab-item>
</tab-set>